/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.oracle.jms;

import java.sql.Driver;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.Session;
import javax.naming.NamingException;
import oracle.jdbc.driver.OracleDriver;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.jms.JmsSupport;
import org.mule.providers.oracle.jms.OracleJmsSupport;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOException;
import org.mule.umo.UMOTransaction;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;

public class OracleJmsConnector
extends JmsConnector {
    public static final String PAYLOADFACTORY_PROPERTY = "payloadFactory";
    private String payloadFactory = null;
    private String url;
    private boolean multipleSessionsPerConnection = false;
    private List connections = new ArrayList();
    private static Log log = LogFactory.getLog((Class)(class$org$mule$providers$oracle$jms$OracleJmsConnector == null ? (class$org$mule$providers$oracle$jms$OracleJmsConnector = OracleJmsConnector.class$("org.mule.providers.oracle.jms.OracleJmsConnector")) : class$org$mule$providers$oracle$jms$OracleJmsConnector));
    static /* synthetic */ Class class$org$mule$providers$oracle$jms$OracleJmsConnector;

    public OracleJmsConnector() {
        this.registerSupportedProtocol("jms");
    }

    public String getProtocol() {
        return "oaq";
    }

    public boolean supportsProtocol(String protocol) {
        return this.getProtocol().equalsIgnoreCase(protocol) || super.getProtocol().equalsIgnoreCase(protocol);
    }

    protected ConnectionFactory createConnectionFactory() throws InitialisationException, NamingException {
        return null;
    }

    public void doInitialise() throws InitialisationException {
        try {
            this.initFromServiceDescriptor();
            this.setJndiDestinations(false);
            this.setForceJndiDestinations(false);
            this.setJmsSupport((JmsSupport)new OracleJmsSupport(this, null, false, false));
            DriverManager.registerDriver((Driver)new OracleDriver());
        }
        catch (Exception e) {
            throw new InitialisationException(new Message(65, (Object)"Oracle Jms Connector"), (Throwable)e, (Object)this);
        }
    }

    protected Connection createConnection() throws NamingException, JMSException, InitialisationException {
        Connection connection = super.createConnection();
        connection.start();
        return connection;
    }

    protected void doDispose() {
        try {
            this.stopConnector();
        }
        catch (UMOException e) {
            this.logger.warn((Object)("Failed to stop during shutdown: " + e.getMessage()), (Throwable)e);
        }
        try {
            Connection jmsConnection = null;
            Iterator i = this.connections.iterator();
            while (i.hasNext()) {
                jmsConnection = (Connection)i.next();
                if (jmsConnection == null) continue;
                jmsConnection.close();
                jmsConnection = null;
            }
        }
        catch (JMSException e) {
            this.logger.error((Object)("Unable to close Oracle JMS connection: " + (Object)((Object)e)));
        }
    }

    public void doStart() throws UMOException {
        Connection jmsConnection = null;
        try {
            Iterator i = this.connections.iterator();
            while (i.hasNext()) {
                jmsConnection = (Connection)i.next();
                if (jmsConnection == null) continue;
                jmsConnection.start();
            }
        }
        catch (JMSException e) {
            throw new LifecycleException(new Message(42, (Object)"Jms Connection"), (Object)e);
        }
    }

    public Session getSession(boolean transacted, boolean topic) throws JMSException {
        if (this.multipleSessionsPerConnection) {
            return super.getSession(transacted, topic);
        }
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        Session session = this.getCurrentSession();
        if (session != null) {
            this.logger.debug((Object)"Retrieving jms session from current transaction");
            return session;
        }
        Connection connection = null;
        try {
            connection = this.createConnection();
        }
        catch (NamingException e) {
            throw new JMSException("Unable to open new database connection.", e.getMessage());
        }
        catch (InitialisationException e) {
            throw new JMSException("Unable to open new database connection.", e.getMessage());
        }
        this.logger.debug((Object)"Retrieving new jms session from connection");
        session = this.getJmsSupport().createSession(connection, topic, transacted || tx != null, this.getAcknowledgementMode(), this.isNoLocal());
        if (tx != null) {
            this.logger.debug((Object)"Binding session to current transaction");
            try {
                tx.bindResource((Object)connection, (Object)session);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind session to current transaction", e);
            }
        }
        return session;
    }

    public Connection getConnection() {
        if (this.multipleSessionsPerConnection) {
            return super.getConnection();
        }
        log.error((Object)"Oracle JMS Connector should not access the generic JMSConnector connection property.");
        return null;
    }

    protected void setConnection(Connection connection) {
        if (this.multipleSessionsPerConnection) {
            super.setConnection(connection);
        } else {
            log.error((Object)"Oracle JMS Connector should not access the generic JMSConnector connection property.");
        }
    }

    public List getConnections() {
        return this.connections;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isMultipleSessionsPerConnection() {
        return this.multipleSessionsPerConnection;
    }

    public void setMultipleSessionsPerConnection(boolean multipleSessionsPerConnection) {
        this.multipleSessionsPerConnection = multipleSessionsPerConnection;
    }

    public String getPayloadFactory() {
        return this.payloadFactory;
    }

    public void setPayloadFactory(String payloadFactory) {
        this.payloadFactory = payloadFactory;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

