/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.oracle.jms;

import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.Topic;
import javax.jms.TopicSession;
import javax.naming.Context;
import oracle.jms.AQjmsQueueConnectionFactory;
import oracle.jms.AQjmsSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.jms.Jms102bSupport;
import org.mule.providers.jms.JmsConnector;
import org.mule.providers.oracle.jms.OracleJmsConnector;

public class OracleJmsSupport
extends Jms102bSupport {
    private Map endpointProperties;
    private static Log log = LogFactory.getLog((Class)(class$org$mule$providers$oracle$jms$OracleJmsSupport == null ? (class$org$mule$providers$oracle$jms$OracleJmsSupport = OracleJmsSupport.class$("org.mule.providers.oracle.jms.OracleJmsSupport")) : class$org$mule$providers$oracle$jms$OracleJmsSupport));
    static /* synthetic */ Class class$org$mule$providers$oracle$jms$OracleJmsSupport;

    public OracleJmsSupport(JmsConnector connector, Context context, boolean jndiDestinations, boolean forceJndiDestinations) {
        super(connector, context, jndiDestinations, forceJndiDestinations);
    }

    public Connection createConnection(ConnectionFactory connectionFactory) throws JMSException {
        return this.createConnection(connectionFactory, null, null);
    }

    public Connection createConnection(ConnectionFactory connectionFactory, String username, String password) throws JMSException {
        QueueConnection jmsConnection = null;
        java.sql.Connection jdbcConnection = null;
        try {
            log.debug((Object)("Creating queue/topic connection, URL = " + ((OracleJmsConnector)this.connector).getUrl()));
            jdbcConnection = username == null ? DriverManager.getConnection(((OracleJmsConnector)this.connector).getUrl()) : DriverManager.getConnection(((OracleJmsConnector)this.connector).getUrl(), username, password);
        }
        catch (SQLException e) {
            throw new JMSException("Unable to open JDBC connection", e.getMessage());
        }
        jmsConnection = AQjmsQueueConnectionFactory.createQueueConnection((java.sql.Connection)jdbcConnection);
        ((OracleJmsConnector)this.connector).getConnections().add(jmsConnection);
        return jmsConnection;
    }

    public MessageConsumer createConsumer(Session session, Destination destination, String messageSelector, boolean noLocal, String durableName) throws JMSException {
        Object payloadFactory = this.getPayloadFactory();
        if (payloadFactory == null) {
            return super.createConsumer(session, destination, messageSelector, noLocal, durableName);
        }
        if (destination == null) {
            throw new IllegalArgumentException("Destination (queue or topic) is missing.");
        }
        if (destination instanceof Queue && session instanceof QueueSession) {
            if (messageSelector != null) {
                return ((AQjmsSession)session).createReceiver((Queue)destination, messageSelector, payloadFactory);
            }
            return ((AQjmsSession)session).createReceiver((Queue)destination, payloadFactory);
        }
        if (destination instanceof Topic && session instanceof TopicSession) {
            if (durableName == null) {
                return ((AQjmsSession)session).createSubscriber((Topic)destination, messageSelector, noLocal);
            }
            return ((AQjmsSession)session).createDurableSubscriber((Topic)destination, messageSelector, durableName, noLocal, payloadFactory);
        }
        throw new IllegalArgumentException("Session and domain type do not match");
    }

    public Destination createDestination(Session session, String name, boolean topic) throws JMSException {
        Destination dest = super.createDestination(session, name, topic);
        if (dest != null) {
            return dest;
        }
        throw new JMSException("Unable to create " + (topic ? "topic" : "queue") + ": " + name);
    }

    public Destination createTemporaryDestination(Session session, boolean topic) throws JMSException {
        Destination dest = super.createTemporaryDestination(session, topic);
        if (dest != null) {
            return dest;
        }
        throw new JMSException("Unable to create temporary " + (topic ? "topic" : "queue"));
    }

    public Object getPayloadFactory() throws JMSException {
        String payloadFactoryClass = ((OracleJmsConnector)this.connector).getPayloadFactory();
        if (this.endpointProperties != null && this.endpointProperties.get("payloadFactory") != null) {
            payloadFactoryClass = (String)this.endpointProperties.get("payloadFactory");
        }
        Object payloadFactory = null;
        if (payloadFactoryClass != null) {
            ReflectiveOperationException ex = null;
            try {
                payloadFactory = Class.forName(payloadFactoryClass).newInstance();
            }
            catch (ClassNotFoundException e) {
                ex = e;
            }
            catch (IllegalAccessException e) {
                ex = e;
            }
            catch (InstantiationException e) {
                ex = e;
            }
            if (ex != null) {
                throw new JMSException("Unable to instantiate payload factory class " + payloadFactoryClass);
            }
        }
        return payloadFactory;
    }

    public Map getEndpointProperties() {
        return this.endpointProperties;
    }

    public void setEndpointProperties(Map endpointProperties) {
        this.endpointProperties = endpointProperties;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

