/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.quartz;

import java.util.Date;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.DefaultMessageAdapter;
import org.mule.providers.quartz.QuartzConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.ClassHelper;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageReceiver
extends AbstractMessageReceiver {
    private static final String PROP_DISPATCHER = "mule.quartz.dispatcher";
    static /* synthetic */ Class class$org$mule$providers$quartz$QuartzMessageReceiver$MuleJob;

    public QuartzMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    protected void doDispose() {
    }

    public void doStart() throws UMOException {
        try {
            QuartzConnector connector = (QuartzConnector)this.connector;
            Scheduler s = connector.getScheduler();
            JobDetail jb = new JobDetail();
            jb.setName(this.endpoint.getEndpointURI().toString());
            jb.setGroup("mule");
            jb.setJobClass(class$org$mule$providers$quartz$QuartzMessageReceiver$MuleJob == null ? (class$org$mule$providers$quartz$QuartzMessageReceiver$MuleJob = QuartzMessageReceiver.class$("org.mule.providers.quartz.QuartzMessageReceiver$MuleJob")) : class$org$mule$providers$quartz$QuartzMessageReceiver$MuleJob);
            JobDataMap map = new JobDataMap();
            map.put((Object)PROP_DISPATCHER, (Object)this);
            jb.setJobDataMap(map);
            CronTrigger trigger = null;
            String cron = this.getStringProperty("cronExpression");
            String itv = this.getStringProperty("repeatInterval");
            String cnt = this.getStringProperty("repeatCount");
            String del = this.getStringProperty("startDelay");
            if (cron != null) {
                CronTrigger ctrigger = new CronTrigger();
                ctrigger.setCronExpression(cron);
                trigger = ctrigger;
            } else if (itv != null) {
                SimpleTrigger strigger = new SimpleTrigger();
                strigger.setRepeatInterval(Long.parseLong(itv));
                if (cnt != null) {
                    strigger.setRepeatCount(Integer.parseInt(cnt));
                } else {
                    strigger.setRepeatCount(-1);
                }
                trigger = strigger;
            } else {
                throw new IllegalArgumentException("One of cron or interval property must be set");
            }
            long start = System.currentTimeMillis();
            if (del != null) {
                start += Long.parseLong(del);
            }
            trigger.setStartTime(new Date(start));
            trigger.setName(this.endpoint.getEndpointURI().toString());
            trigger.setGroup("mule");
            trigger.setJobName(this.endpoint.getEndpointURI().toString());
            trigger.setJobGroup("mule");
            s.scheduleJob(jb, (Trigger)trigger);
            s.start();
        }
        catch (Exception e) {
            throw new EndpointException(new Message(42, (Object)"Quartz receiver"), (Throwable)e);
        }
    }

    private String getStringProperty(String name) {
        Object o = this.endpoint.getProperties().get(name);
        if (o != null) {
            return o.toString();
        }
        return null;
    }

    private Object getProperty(String name) {
        return this.endpoint.getProperties().get(name);
    }

    protected void onTrigger() {
        try {
            String payloadClassName;
            Object payload = this.getProperty("payload");
            if (payload == null && (payloadClassName = this.getStringProperty("payloadClassName")) != null) {
                payload = ClassHelper.instanciateClass((String)payloadClassName, null);
            }
            this.routeMessage((UMOMessage)new MuleMessage((UMOMessageAdapter)new DefaultMessageAdapter(payload)));
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class MuleJob
    implements Job {
        public void execute(JobExecutionContext context) throws JobExecutionException {
            JobDataMap map = context.getJobDetail().getJobDataMap();
            QuartzMessageReceiver receiver = (QuartzMessageReceiver)((Object)map.get((Object)QuartzMessageReceiver.PROP_DISPATCHER));
            receiver.onTrigger();
        }
    }
}

