/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.quartz;

import java.util.Date;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.quartz.QuartzConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.util.ClassHelper;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageDispatcher
extends AbstractMessageDispatcher {
    static /* synthetic */ Class class$org$mule$providers$quartz$jobs$DelegatingJob;

    public QuartzMessageDispatcher(AbstractConnector connector) {
        super(connector);
    }

    public void doDispose() {
    }

    public void doDispatch(UMOEvent event) throws Exception {
        JobDetail jobDetail = new JobDetail();
        jobDetail.setName(event.getEndpoint().getEndpointURI().toString());
        JobDataMap jobDataMap = new JobDataMap();
        jobDataMap.putAll(event.getProperties());
        jobDetail.setJobDataMap(jobDataMap);
        Object payload = event.getTransformedMessage();
        String jobClass = jobDataMap.getString("jobClass");
        if (payload instanceof Job) {
            Job job = (Job)payload;
            jobDataMap.put((Object)"jobObject", (Object)job);
            jobDetail.setJobClass(class$org$mule$providers$quartz$jobs$DelegatingJob == null ? (class$org$mule$providers$quartz$jobs$DelegatingJob = QuartzMessageDispatcher.class$("org.mule.providers.quartz.jobs.DelegatingJob")) : class$org$mule$providers$quartz$jobs$DelegatingJob);
        } else if (jobClass != null) {
            jobDetail.setJobClass(ClassHelper.loadClass((String)jobClass, ((Object)((Object)this)).getClass()));
        } else {
            Object tempJob = jobDataMap.get((Object)"jobObject");
            if (tempJob == null) {
                tempJob = jobDataMap.get((Object)"jobRef");
                if (tempJob == null) {
                    throw new DispatchException(new Message("quartz", 2), event.getMessage(), event.getEndpoint());
                }
                tempJob = MuleManager.getInstance().getContainerContext().getComponent(tempJob);
                if (!(tempJob instanceof Job)) {
                    throw new DispatchException(new Message("quartz", 3), event.getMessage(), event.getEndpoint());
                }
            } else if (!(tempJob instanceof Job)) {
                throw new DispatchException(new Message("quartz", 3), event.getMessage(), event.getEndpoint());
            }
            jobDetail.setJobClass(class$org$mule$providers$quartz$jobs$DelegatingJob == null ? (class$org$mule$providers$quartz$jobs$DelegatingJob = QuartzMessageDispatcher.class$("org.mule.providers.quartz.jobs.DelegatingJob")) : class$org$mule$providers$quartz$jobs$DelegatingJob);
        }
        jobDataMap.put((Object)"payload", payload);
        CronTrigger trigger = null;
        String cronExpression = jobDataMap.getString("cronExpression");
        String repeatInterval = jobDataMap.getString("repeatInterval");
        String repeatCount = jobDataMap.getString("repeatCount");
        String startDelay = jobDataMap.getString("startDelay");
        String groupName = jobDataMap.getString("groupName");
        String jobGroupName = jobDataMap.getString("jobGroupName");
        if (groupName == null) {
            groupName = "mule";
        }
        if (jobGroupName == null) {
            jobGroupName = groupName;
        }
        jobDetail.setGroup(groupName);
        if (cronExpression != null) {
            CronTrigger ctrigger = new CronTrigger();
            ctrigger.setCronExpression(cronExpression);
            trigger = ctrigger;
        } else if (repeatInterval != null) {
            SimpleTrigger strigger = new SimpleTrigger();
            strigger.setRepeatInterval(Long.parseLong(repeatInterval));
            if (repeatCount != null) {
                strigger.setRepeatCount(Integer.parseInt(repeatCount));
            } else {
                strigger.setRepeatCount(-1);
            }
            trigger = strigger;
        } else {
            throw new IllegalArgumentException(new Message("quartz", 1).getMessage());
        }
        long start = System.currentTimeMillis();
        if (startDelay != null) {
            start += Long.parseLong(startDelay);
        }
        trigger.setStartTime(new Date(start));
        trigger.setName(event.getEndpoint().getEndpointURI().toString());
        trigger.setGroup(groupName);
        trigger.setJobName(event.getEndpoint().getEndpointURI().toString());
        trigger.setJobGroup(jobGroupName);
        Scheduler scheduler = ((QuartzConnector)this.connector).getScheduler();
        scheduler.scheduleJob(jobDetail, (Trigger)trigger);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        throw new UnsupportedOperationException("receive is not implemented on the Quartz provider");
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

