/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.quartz;

import java.util.Date;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.quartz.QuartzConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;

public class QuartzMessageReceiver
extends AbstractMessageReceiver {
    public static final String QUARTZ_RECEIVER_PROPERTY = "mule.quartz.receiver";
    private QuartzConnector connector = null;
    static /* synthetic */ Class class$org$mule$providers$quartz$jobs$MuleReceiverJob;

    public QuartzMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (QuartzConnector)connector;
    }

    protected void doDispose() {
    }

    public void doStart() throws UMOException {
        try {
            Scheduler scheduler = this.connector.getScheduler();
            JobDetail jobDetail = new JobDetail();
            jobDetail.setName(this.endpoint.getEndpointURI().toString());
            jobDetail.setJobClass(class$org$mule$providers$quartz$jobs$MuleReceiverJob == null ? (class$org$mule$providers$quartz$jobs$MuleReceiverJob = QuartzMessageReceiver.class$("org.mule.providers.quartz.jobs.MuleReceiverJob")) : class$org$mule$providers$quartz$jobs$MuleReceiverJob);
            JobDataMap jobDataMap = new JobDataMap();
            jobDataMap.put((Object)QUARTZ_RECEIVER_PROPERTY, (Object)this);
            jobDataMap.putAll(this.endpoint.getProperties());
            jobDetail.setJobDataMap(jobDataMap);
            CronTrigger trigger = null;
            String cronExpression = jobDataMap.getString("cronExpression");
            String repeatInterval = jobDataMap.getString("repeatInterval");
            String repeatCount = jobDataMap.getString("repeatCount");
            String startDelay = jobDataMap.getString("startDelay");
            String groupName = jobDataMap.getString("groupName");
            String jobGroupName = jobDataMap.getString("jobGroupName");
            if (groupName == null) {
                groupName = "mule";
            }
            if (jobGroupName == null) {
                jobGroupName = groupName;
            }
            jobDetail.setGroup(groupName);
            if (cronExpression != null) {
                CronTrigger ctrigger = new CronTrigger();
                ctrigger.setCronExpression(cronExpression);
                trigger = ctrigger;
            } else if (repeatInterval != null) {
                SimpleTrigger strigger = new SimpleTrigger();
                strigger.setRepeatInterval(Long.parseLong(repeatInterval));
                if (repeatCount != null) {
                    strigger.setRepeatCount(Integer.parseInt(repeatCount));
                } else {
                    strigger.setRepeatCount(-1);
                }
                trigger = strigger;
            } else {
                throw new IllegalArgumentException(new Message("quartz", 1).getMessage());
            }
            long start = System.currentTimeMillis();
            if (startDelay != null) {
                start += Long.parseLong(startDelay);
            }
            trigger.setStartTime(new Date(start));
            trigger.setName(this.endpoint.getEndpointURI().toString());
            trigger.setGroup(groupName);
            trigger.setJobName(this.endpoint.getEndpointURI().toString());
            trigger.setJobGroup(jobGroupName);
            scheduler.scheduleJob(jobDetail, (Trigger)trigger);
            scheduler.start();
        }
        catch (Exception e) {
            throw new EndpointException(new Message(42, (Object)"Quartz receiver"), (Throwable)e);
        }
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

