/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.quartz.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.extras.client.MuleClient;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOException;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MuleClientDispatchJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        String dispatchEndpoint;
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        Object payload = jobDataMap.get((Object)"payload");
        if (payload == null) {
            payload = new NullPayload();
        }
        if ((dispatchEndpoint = jobDataMap.getString("jobDispatchEndpoint")) == null) {
            throw new JobExecutionException(new Message("quartz", 4, (Object)"jobDispatchEndpoint").getMessage());
        }
        try {
            MuleClient client = new MuleClient();
            this.logger.debug((Object)("Dispatching payload on: " + dispatchEndpoint));
            client.dispatch(dispatchEndpoint, payload, (Map)jobDataMap);
        }
        catch (UMOException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }
}

