/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.quartz.jobs;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.extras.client.MuleClient;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MuleClientReceiveJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap jobDataMap = jobExecutionContext.getJobDetail().getJobDataMap();
        String dispatchEndpoint = jobDataMap.getString("jobDispatchEndpoint");
        if (dispatchEndpoint == null) {
            throw new JobExecutionException(new Message("quartz", 4, (Object)"jobDispatchEndpoint").getMessage());
        }
        String receiveEndpoint = jobDataMap.getString("jobReceiveEndpoint");
        if (receiveEndpoint == null) {
            throw new JobExecutionException(new Message("quartz", 4, (Object)"jobReceiveEndpoint").getMessage());
        }
        long timeout = MuleManager.getConfiguration().getSynchronousEventTimeout();
        String timeoutString = jobDataMap.getString("jobReceiveTimeout");
        if (timeoutString != null) {
            timeout = Long.parseLong(timeoutString);
        }
        try {
            MuleClient client = new MuleClient();
            this.logger.debug((Object)("Attempting to receive event on: " + receiveEndpoint));
            UMOMessage result = client.receive(receiveEndpoint, timeout);
            if (result != null) {
                this.logger.debug((Object)("Received event on: " + receiveEndpoint));
                this.logger.debug((Object)("Dispatching result on: " + dispatchEndpoint));
                result.addProperties((Map)jobDataMap);
                client.dispatch(dispatchEndpoint, result);
            }
        }
        catch (UMOException e) {
            throw new JobExecutionException((Exception)((Object)e));
        }
    }
}

