/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.quartz.jobs;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.NullPayload;
import org.mule.umo.UMOMessage;
import org.mule.umo.manager.ObjectNotFoundException;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MuleReceiverJob
implements Job {
    protected transient Log logger = LogFactory.getLog(this.getClass());

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        JobDataMap map = jobExecutionContext.getJobDetail().getJobDataMap();
        AbstractMessageReceiver receiver = (AbstractMessageReceiver)map.get((Object)"mule.quartz.receiver");
        Object payload = jobExecutionContext.getJobDetail().getJobDataMap().get((Object)"payload");
        try {
            if (payload == null) {
                String ref = jobExecutionContext.getJobDetail().getJobDataMap().getString("payloadRef");
                if (ref == null) {
                    ref = jobExecutionContext.getJobDetail().getJobDataMap().getString("payloadClassName");
                }
                try {
                    payload = MuleManager.getInstance().getContainerContext().getComponent((Object)ref);
                }
                catch (ObjectNotFoundException e) {
                    this.logger.warn((Object)"There is no payload attached to this quartz job. Sending Null payload");
                    payload = new NullPayload();
                }
            }
            receiver.routeMessage((UMOMessage)new MuleMessage((Object)receiver.getConnector().getMessageAdapter(payload)));
        }
        catch (Exception e) {
            receiver.handleException(e);
        }
    }
}

