/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ra;

import java.util.Map;
import javax.resource.ResourceException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleEvent;
import org.mule.impl.MuleMessage;
import org.mule.impl.MuleSession;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.impl.security.MuleCredentials;
import org.mule.ra.MuleConnection;
import org.mule.ra.MuleManagedConnection;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.UMOSession;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.manager.UMOManager;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;

public class DefaultMuleConnection
implements MuleConnection {
    private MuleCredentials credentials;
    private UMOManager manager;
    private MuleManagedConnection managedConnection;

    public DefaultMuleConnection(MuleManagedConnection managedConnection, UMOManager manager, MuleCredentials credentials) {
        this.manager = manager;
        this.credentials = credentials;
        this.managedConnection = managedConnection;
    }

    public void dispatch(String url, Object payload, Map messageProperties) throws UMOException {
        MuleEndpointURI muleEndpoint = new MuleEndpointURI(url);
        MuleMessage message = new MuleMessage(payload, messageProperties);
        UMOEvent event = this.getEvent((UMOMessage)message, (UMOEndpointURI)muleEndpoint, false);
        try {
            event.getSession().dispatchEvent(event);
        }
        catch (UMOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DispatchException(new Message("client", 1), event.getMessage(), event.getEndpoint(), (Throwable)e);
        }
    }

    public UMOMessage receive(String url, long timeout) throws UMOException {
        MuleEndpointURI muleEndpoint = new MuleEndpointURI(url);
        UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri((UMOEndpointURI)muleEndpoint, (String)"sender");
        try {
            UMOMessage message = endpoint.getConnector().getDispatcher(muleEndpoint.getAddress()).receive((UMOEndpointURI)muleEndpoint, timeout);
            return message;
        }
        catch (Exception e) {
            throw new ReceiveException((UMOEndpointURI)muleEndpoint, timeout, (Throwable)e);
        }
    }

    protected UMOEvent getEvent(UMOMessage message, UMOEndpointURI uri, boolean synchronous) throws UMOException {
        UMOEndpoint endpoint = MuleEndpoint.getOrCreateEndpointForUri((UMOEndpointURI)uri, (String)"sender");
        if (!endpoint.getConnector().isStarted() && this.manager.isStarted()) {
            endpoint.getConnector().startConnector();
        }
        try {
            MuleSession session = new MuleSession();
            if (this.credentials != null) {
                message.setProperty((Object)"MULE_USER", (Object)("Plain " + this.credentials.getToken()));
            }
            MuleEvent event = new MuleEvent(message, endpoint, (UMOSession)session, synchronous);
            return event;
        }
        catch (Exception e) {
            throw new DispatchException(new Message(65, (Object)"Client event"), message, endpoint, (Throwable)e);
        }
    }

    public MuleManagedConnection getManagedConnection() {
        return this.managedConnection;
    }

    public void close() throws ResourceException {
        if (this.managedConnection == null) {
            return;
        }
        this.managedConnection.removeConnection(this);
        this.managedConnection.fireCloseEvent(this);
        this.managedConnection = null;
    }

    public void associateConnection(MuleManagedConnection newMc) throws ResourceException {
        this.checkIfValid();
        this.managedConnection.removeConnection(this);
        newMc.addConnection(this);
        this.managedConnection = newMc;
    }

    void checkIfValid() throws ResourceException {
        if (this.managedConnection == null) {
            throw new ResourceException(new Message(154, (Object)"muleManagedConnection").toString());
        }
    }

    void invalidate() {
        this.managedConnection = null;
    }
}

