/*
 * Decompiled with CFR 0.152.
 */
package org.mule.ra;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionEventListener;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.LocalTransaction;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionMetaData;
import javax.resource.spi.security.PasswordCredential;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.impl.security.MuleCredentials;
import org.mule.ra.DefaultMuleConnection;
import org.mule.ra.MuleConnection;
import org.mule.ra.MuleConnectionRequestInfo;
import org.mule.ra.MuleManagedConnectionFactory;
import org.mule.ra.MuleManagedConnectionMetaData;
import org.mule.ra.RaHelper;

public class MuleManagedConnection
implements ManagedConnection {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$ra$MuleManagedConnection == null ? (class$org$mule$ra$MuleManagedConnection = MuleManagedConnection.class$("org.mule.ra.MuleManagedConnection")) : class$org$mule$ra$MuleManagedConnection));
    private MuleManagedConnectionFactory mcf;
    private ArrayList listeners = new ArrayList();
    private Set connectionSet;
    private PrintWriter logWriter;
    private boolean destroyed;
    private PasswordCredential passCred = null;
    static /* synthetic */ Class class$org$mule$ra$MuleManagedConnection;
    static /* synthetic */ Class class$org$mule$ra$DefaultMuleConnection;

    MuleManagedConnection(MuleManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo cxRequestInfo) throws ResourceException {
        this.mcf = mcf;
        this.passCred = RaHelper.getPasswordCredential(mcf, subject, cxRequestInfo);
        this.connectionSet = new HashSet();
    }

    public Object getConnection(Subject subject, ConnectionRequestInfo connectionRequestInfo) throws ResourceException {
        this.checkIfDestroyed();
        PasswordCredential pc = RaHelper.getPasswordCredential(this.mcf, subject, connectionRequestInfo);
        if (!pc.equals((Object)this.passCred)) {
            throw new SecurityException(new Message(134, (Object)this).getMessage());
        }
        MuleConnectionRequestInfo info = (MuleConnectionRequestInfo)connectionRequestInfo;
        String user = info.getUserName();
        String password = info.getPassword();
        if (user == null) {
            user = this.mcf.getUsername();
            password = this.mcf.getPassword();
        }
        MuleCredentials creds = null;
        if (user != null) {
            if (password == null) {
                password = "";
            }
            creds = new MuleCredentials(user, password.toCharArray());
        }
        DefaultMuleConnection connection = new DefaultMuleConnection(this, info.getManager(), creds);
        this.addConnection(connection);
        return connection;
    }

    public void destroy() throws ResourceException {
        if (this.destroyed) {
            return;
        }
        this.destroyed = true;
        this.invalidateConnections();
    }

    public void cleanup() throws ResourceException {
        this.checkIfDestroyed();
        this.invalidateConnections();
    }

    private void invalidateConnections() {
        Iterator it = this.connectionSet.iterator();
        while (it.hasNext()) {
            DefaultMuleConnection connection = (DefaultMuleConnection)it.next();
            connection.invalidate();
        }
        this.connectionSet.clear();
    }

    public void associateConnection(Object connection) throws ResourceException {
        this.checkIfDestroyed();
        if (!(connection instanceof MuleConnection)) {
            throw new IllegalStateException(new Message(154, (Object)((class$org$mule$ra$DefaultMuleConnection == null ? (class$org$mule$ra$DefaultMuleConnection = MuleManagedConnection.class$("org.mule.ra.DefaultMuleConnection")) : class$org$mule$ra$DefaultMuleConnection).getName() + ": " + (connection == null ? "null" : connection.getClass().getName()))).toString());
        }
        MuleConnection cnn = (MuleConnection)connection;
        cnn.associateConnection(this);
    }

    public void addConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.add(listener);
    }

    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this.listeners.remove(listener);
    }

    public XAResource getXAResource() throws ResourceException {
        throw new NotSupportedException("getXAResource");
    }

    public LocalTransaction getLocalTransaction() throws ResourceException {
        throw new NotSupportedException("getLocalTransaction");
    }

    public ManagedConnectionMetaData getMetaData() throws ResourceException {
        this.checkIfDestroyed();
        return new MuleManagedConnectionMetaData(this);
    }

    public void setLogWriter(PrintWriter out) throws ResourceException {
        this.logWriter = out;
    }

    public PrintWriter getLogWriter() throws ResourceException {
        return this.logWriter;
    }

    public String getUsername() {
        if (this.passCred != null) {
            return this.passCred.getUserName();
        }
        return null;
    }

    public PasswordCredential getPasswordCredential() {
        return this.passCred;
    }

    public void addConnection(MuleConnection connection) {
        this.connectionSet.add(connection);
    }

    private void checkIfDestroyed() throws ResourceException {
        if (this.destroyed) {
            throw new ResourceException(new Message(153, (Object)"MuleManagedConnection").toString());
        }
    }

    public void removeConnection(MuleConnection connection) {
        this.connectionSet.remove(connection);
    }

    boolean isDestroyed() {
        return this.destroyed;
    }

    public MuleManagedConnectionFactory getManagedConnectionFactory() {
        return this.mcf;
    }

    void fireBeginEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 2);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.localTransactionStarted(event);
        }
    }

    void fireCommitEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 3);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.localTransactionCommitted(event);
        }
    }

    void fireRollbackEvent() {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 4);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.localTransactionRolledback(event);
        }
    }

    void fireCloseEvent(MuleConnection connection) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 1);
        event.setConnectionHandle((Object)connection);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.connectionClosed(event);
        }
    }

    void fireErrorOccurredEvent(Exception error) {
        ConnectionEvent event = new ConnectionEvent((ManagedConnection)this, 5, error);
        Iterator iterator = this.listeners.iterator();
        while (iterator.hasNext()) {
            ConnectionEventListener l = (ConnectionEventListener)iterator.next();
            l.connectionErrorOccurred(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

