/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.events.ModelEventListener;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.axis.AxisInitialisationCallback;
import org.mule.providers.soap.axis.AxisMessageReceiver;
import org.mule.providers.soap.axis.extensions.MuleConfigProvider;
import org.mule.providers.soap.axis.extensions.MuleProvider;
import org.mule.providers.soap.axis.extensions.WSDDJavaMuleProvider;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.manager.UMOServerEventListener;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassHelper;

public class AxisConnector
extends AbstractServiceEnabledConnector
implements ModelEventListener {
    public static final QName QNAME_MULERPC_PROVIDER = new QName("http://xml.apache.org/axis/wsdd/providers/java", "Mule");
    public static final QName QNAME_MULE_TYPE_MAPPINGS = new QName("http://www.muleumo.org/ws/mappings", "Mule");
    public static final String DEFAULT_MULE_AXIS_SERVER_CONFIG = "mule-axis-server-config.wsdd";
    public static final String DEFAULT_MULE_AXIS_CLIENT_CONFIG = "mule-axis-client-config.wsdd";
    public static final String AXIS_SERVICE_COMPONENT_NAME = "_axisServiceComponent";
    public static final String SERVICE_PROPERTY_COMPONENT_NAME = "componentName";
    public static final String SERVICE_PROPERTY_SERVCE_PATH = "servicePath";
    private String serverConfig;
    private AxisServer axisServer;
    private SimpleProvider serverProvider;
    private String clientConfig;
    private SimpleProvider clientProvider;
    private List beanTypes;
    private MuleDescriptor axisDescriptor;
    static /* synthetic */ Class class$org$mule$providers$soap$axis$AxisServiceComponent;

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        MuleManager.getInstance().registerListener((UMOServerEventListener)this);
        if (this.serverConfig == null) {
            this.serverConfig = DEFAULT_MULE_AXIS_SERVER_CONFIG;
        }
        if (this.clientConfig == null) {
            this.clientConfig = DEFAULT_MULE_AXIS_CLIENT_CONFIG;
        }
        this.serverProvider = this.createAxisProvider(this.serverConfig);
        this.clientProvider = this.createAxisProvider(this.clientConfig);
        this.axisServer = new AxisServer((EngineConfiguration)this.serverProvider);
        WSDDProvider.registerProvider((QName)QNAME_MULERPC_PROVIDER, (WSDDProvider)new WSDDJavaMuleProvider(this));
    }

    protected SimpleProvider createAxisProvider(String config) throws InitialisationException {
        InputStream is = null;
        File f = new File(config);
        if (f.exists()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {}
        } else {
            is = ClassHelper.getResourceAsStream((String)config, ((Object)((Object)this)).getClass());
        }
        FileProvider fileProvider = new FileProvider(config);
        if (is == null) {
            throw new InitialisationException(new Message(58, (Object)("Axis Configuration: " + config)), (Object)this);
        }
        fileProvider.setInputStream(is);
        return new MuleConfigProvider((EngineConfiguration)fileProvider);
    }

    public String getProtocol() {
        return "axis";
    }

    public AxisMessageReceiver getReceiver(String name) {
        return (AxisMessageReceiver)((Object)this.receivers.get((Object)name));
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return component.getDescriptor().getName();
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint instanceof ImmutableMuleEndpoint && !((ImmutableMuleEndpoint)endpoint).isSynchronousExplicitlySet() && !endpoint.isSynchronous()) {
            this.logger.debug((Object)"overriding endpoint synchronicity and setting it to true. Web service requests are executed in a single thread");
            endpoint.setSynchronous(true);
        }
        UMOMessageReceiver receiver = super.createReceiver(component, endpoint);
        this.registerAxisComponent(receiver);
        return receiver;
    }

    protected void registerAxisComponent(UMOMessageReceiver receiver) throws AxisFault, UMOException, ClassNotFoundException, URISyntaxException {
        SOAPService service = new SOAPService((Handler)new MuleProvider(this));
        service.setEngine((AxisEngine)this.axisServer);
        UMOEndpointURI uri = receiver.getEndpoint().getEndpointURI();
        String serviceName = receiver.getComponent().getDescriptor().getName();
        String servicePath = uri.getPath();
        service.setOption(serviceName, (Object)receiver);
        service.setOption(SERVICE_PROPERTY_SERVCE_PATH, (Object)servicePath);
        service.setOption(SERVICE_PROPERTY_COMPONENT_NAME, (Object)serviceName);
        service.setName(serviceName);
        Map options = (Map)receiver.getComponent().getDescriptor().getProperties().get("axisOptions");
        if (options != null) {
            Iterator iterator = options.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                service.setOption(entry.getKey().toString(), entry.getValue());
                this.logger.debug((Object)("Adding Axis option: " + entry));
            }
        }
        Class[] interfaces = ServiceProxy.getInterfacesForComponent(receiver.getComponent());
        String methodNames = "*";
        String[] methods = ServiceProxy.getMethodNames(interfaces);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < methods.length; ++i) {
            buf.append(methods[i]).append(",");
        }
        String className = interfaces[0].getName();
        methodNames = buf.toString();
        methodNames = methodNames.substring(0, methodNames.length() - 1);
        String namespace = Namespaces.makeNamespace((String)className);
        this.setOptionIfNotset(service, "wsdlServicePort", serviceName);
        this.setOptionIfNotset(service, "className", className);
        this.setOptionIfNotset(service, "scope", "Request");
        this.setOptionIfNotset(service, "wsdlTargetNamespace", namespace);
        if (methodNames == null) {
            this.setOptionIfNotset(service, "allowedMethods", "*");
        } else {
            this.setOptionIfNotset(service, "allowedMethods", methodNames);
        }
        ServiceDesc sd = service.getInitializedServiceDesc(null);
        sd.setName(serviceName);
        sd.setEndpointURL(uri.getAddress() + "/" + serviceName);
        String style = (String)receiver.getComponent().getDescriptor().getProperties().get("style");
        String use = (String)receiver.getComponent().getDescriptor().getProperties().get("use");
        String doc = (String)receiver.getComponent().getDescriptor().getProperties().get("documentation");
        if (style != null) {
            sd.setStyle(Style.getStyle((String)style));
        }
        if (use != null) {
            sd.setUse(Use.getUse((String)use));
        }
        sd.setDocumentation(doc);
        TypeMappingRegistryImpl registry = (TypeMappingRegistryImpl)service.getTypeMappingRegistry();
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)"true");
        List types = (List)receiver.getComponent().getDescriptor().getProperties().get("beanTypes");
        this.registerTypes(registry, types);
        this.registerTypes(registry, this.beanTypes);
        service.setName(serviceName);
        this.serverProvider.deployService(serviceName, service);
        MuleDescriptor desc = (MuleDescriptor)receiver.getComponent().getDescriptor();
        desc.addInitialisationCallback((InitialisationCallback)new AxisInitialisationCallback(service));
        this.registerReceiverWithMuleService(receiver, uri);
    }

    protected void registerReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        if (this.axisDescriptor == null) {
            this.axisDescriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor(AXIS_SERVICE_COMPONENT_NAME);
            if (this.axisDescriptor == null) {
                this.axisDescriptor = new MuleDescriptor(AXIS_SERVICE_COMPONENT_NAME);
                this.axisDescriptor.setImplementation((Object)(class$org$mule$providers$soap$axis$AxisServiceComponent == null ? (class$org$mule$providers$soap$axis$AxisServiceComponent = AxisConnector.class$("org.mule.providers.soap.axis.AxisServiceComponent")) : class$org$mule$providers$soap$axis$AxisServiceComponent).getName());
            } else {
                MuleManager.getInstance().getModel().unregisterComponent((UMODescriptor)this.axisDescriptor);
            }
            if (this.axisDescriptor.getProperties().get("axisServer") == null) {
                this.axisDescriptor.getProperties().put("axisServer", this.axisServer);
            }
            this.axisDescriptor.setContainerManaged(false);
        }
        String endpoint = receiver.getEndpointURI().getAddress();
        boolean startsWith = false;
        String scheme = ep.getScheme().toLowerCase();
        if (scheme.equals("http") || scheme.equals("tcp")) {
            endpoint = scheme + "://" + ep.getHost() + ":" + ep.getPort();
            startsWith = true;
            String sync = "synchronous=" + receiver.getEndpoint().isSynchronous();
            endpoint = endpoint.indexOf("?") > -1 ? endpoint + "&" + sync : endpoint + "?" + sync;
        }
        boolean registered = false;
        Iterator iterator = this.axisDescriptor.getInboundRouter().getEndpoints().iterator();
        while (iterator.hasNext()) {
            UMOEndpoint umoEndpoint = (UMOEndpoint)iterator.next();
            if ((!startsWith || !endpoint.startsWith(umoEndpoint.getEndpointURI().getAddress())) && (startsWith || !endpoint.startsWith(umoEndpoint.getEndpointURI().getAddress()))) continue;
            registered = true;
            break;
        }
        if (!registered) {
            MuleEndpoint serviceEndpoint = new MuleEndpoint(endpoint, true);
            serviceEndpoint.setName(ep.getScheme() + ":" + receiver.getComponent().getDescriptor().getName());
            serviceEndpoint.setFilter(receiver.getEndpoint().getFilter());
            this.axisDescriptor.getInboundRouter().addEndpoint((UMOEndpoint)serviceEndpoint);
        }
    }

    protected void setOptionIfNotset(SOAPService service, String option, Object value) {
        Object val = service.getOption(option);
        if (val == null) {
            service.setOption(option, value);
        }
    }

    protected void registerTypes(TypeMappingRegistryImpl registry, List types) throws ClassNotFoundException {
        if (types != null) {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                Class clazz = ClassHelper.loadClass((String)iterator.next().toString(), ((Object)((Object)this)).getClass());
                QName xmlType = new QName(Namespaces.makeNamespace((String)clazz.getName()), Types.getLocalNameFromFullName((String)clazz.getName()));
                registry.getDefaultTypeMapping().register(clazz, xmlType, (SerializerFactory)new BeanSerializerFactory(clazz, xmlType), (DeserializerFactory)new BeanDeserializerFactory(clazz, xmlType));
            }
        }
    }

    protected void startConnector() throws UMOException {
        this.axisServer.start();
    }

    protected void stopConnector() throws UMOException {
        this.axisServer.stop();
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public List getBeanTypes() {
        return this.beanTypes;
    }

    public void setBeanTypes(List beanTypes) {
        this.beanTypes = beanTypes;
    }

    public void onEvent(UMOServerEvent event) {
        if (event.getAction() == 206 && !MuleManager.getInstance().getModel().isComponentRegistered(AXIS_SERVICE_COMPONENT_NAME)) {
            try {
                MuleManager.getInstance().getModel().registerComponent((UMODescriptor)this.axisDescriptor);
            }
            catch (UMOException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    public String getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    public AxisServer getAxisServer() {
        return this.axisServer;
    }

    public void setAxisServer(AxisServer axisServer) {
        this.axisServer = axisServer;
    }

    public SimpleProvider getServerProvider() {
        return this.serverProvider;
    }

    public void setServerProvider(SimpleProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public SimpleProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(SimpleProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

