/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import javax.xml.rpc.ServiceException;
import javax.xml.soap.SOAPEnvelope;
import org.apache.axis.AxisEngine;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.SimpleProvider;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.NullPayload;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.extensions.MuleHttpSender;
import org.mule.providers.soap.axis.extensions.MuleSoapHeadersHandler;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.TransformerException;

public class AxisMessageDispatcher
extends AbstractMessageDispatcher {
    private Service service;

    public AxisMessageDispatcher(AxisConnector connector) {
        super((AbstractConnector)connector);
        try {
            this.service = new Service();
            SimpleProvider clientConfig = new SimpleProvider();
            MuleSoapHeadersHandler muleHandler = new MuleSoapHeadersHandler();
            SimpleChain reqHandler = new SimpleChain();
            SimpleChain respHandler = new SimpleChain();
            reqHandler.addHandler((Handler)muleHandler);
            respHandler.addHandler((Handler)muleHandler);
            MuleHttpSender pivot = new MuleHttpSender();
            SimpleTargetedChain transport = new SimpleTargetedChain((Handler)reqHandler, (Handler)pivot, (Handler)respHandler);
            clientConfig.deployTransport("http", (Handler)transport);
            this.service.setEngineConfiguration((EngineConfiguration)clientConfig);
            this.service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)clientConfig));
        }
        catch (Exception e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    public void doDispose() {
    }

    public void doDispatch(UMOEvent event) throws Exception {
        Call call = this.getCall(event);
        Object[] args = this.getArgs(event);
        call.setProperty("axis.one.way", (Object)Boolean.TRUE);
        call.invoke(args);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        Call call = this.getCall(event);
        Object result = call.invoke(this.getArgs(event));
        if (result == null) {
            return null;
        }
        MuleMessage resultMessage = new MuleMessage(result, event.getProperties());
        this.setMessageContextProperties((UMOMessage)resultMessage, call.getMessageContext());
        return resultMessage;
    }

    private Call getCall(UMOEvent event) throws ServiceException, DispatchException {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String method = (String)endpointUri.getParams().remove("method");
        if (method == null && (method = (String)event.getEndpoint().getProperties().get("method")) == null) {
            throw new DispatchException(new Message("soap", 4), event.getMessage(), event.getEndpoint());
        }
        Call call = (Call)this.service.createCall();
        call.setTargetEndpointAddress(endpointUri.getAddress());
        call.setSOAPActionURI(endpointUri.getAddress());
        call.setOperationName(method);
        call.setProperty("MULE_EVENT", (Object)event);
        return call;
    }

    private Object[] getArgs(UMOEvent event) throws TransformerException {
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        return args;
    }

    private void setMessageContextProperties(UMOMessage message, MessageContext ctx) {
        Object temp = ctx.getProperty("MULE_CORRELATION_ID");
        if (temp != null && !"".equals(temp.toString())) {
            message.setCorrelationId(temp.toString());
        }
        if ((temp = ctx.getProperty("MULE_CORRELATION_GROUP")) != null && !"".equals(temp.toString())) {
            message.setCorrelationGroupSize(Integer.parseInt(temp.toString()));
        }
        if ((temp = ctx.getProperty("MULE_CORRELATION_SEQUENCE")) != null && !"".equals(temp.toString())) {
            message.setCorrelationSequence(Integer.parseInt(temp.toString()));
        }
        if ((temp = ctx.getProperty("MULE_REPLYTO")) != null && !"".equals(temp.toString())) {
            message.setReplyTo((Object)temp.toString());
        }
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        String address = endpointUri.getAddress();
        Call call = new Call(address);
        call.setSOAPActionURI(address);
        call.setTargetEndpointAddress(address);
        String method = (String)endpointUri.getParams().remove("method");
        call.setOperationName(method);
        Properties params = endpointUri.getUserParams();
        Object[] args = new Object[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next();
            ++i;
        }
        call.setOperationName(method);
        Object result = call.invoke(method, args);
        return this.createMessage(result, call);
    }

    public UMOMessage receive(String endpoint, Object[] args) throws Exception {
        Call call = new Call(endpoint);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        if (!endpoint.startsWith("axis:")) {
            endpoint = "axis:" + endpoint;
        }
        MuleEndpointURI ep = new MuleEndpointURI(endpoint);
        String method = (String)ep.getParams().remove("method");
        call.setOperationName(method);
        call.setOperationName(method);
        Object result = call.invoke(method, args);
        return this.createMessage(result, call);
    }

    public UMOMessage receive(String endpoint, SOAPEnvelope envelope) throws Exception {
        Call call = new Call(endpoint);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        org.apache.axis.message.SOAPEnvelope result = call.invoke(new org.apache.axis.Message((Object)envelope));
        return this.createMessage(result, call);
    }

    protected UMOMessage createMessage(Object result, Call call) {
        if (result == null) {
            result = new NullPayload();
        }
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        Iterator iter = call.getMessageContext().getPropertyNames();
        while (iter.hasNext()) {
            Object key = iter.next();
            props.put(key, call.getMessageContext().getProperty(key.toString()));
        }
        props.put("soap.message", call.getMessageContext().getMessage());
        return new MuleMessage(result, props);
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }
}

