/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPException;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisFault;
import org.apache.axis.ConfigurationException;
import org.apache.axis.Constants;
import org.apache.axis.Message;
import org.apache.axis.MessageContext;
import org.apache.axis.components.logger.LogFactory;
import org.apache.axis.description.OperationDesc;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.i18n.Messages;
import org.apache.axis.security.servlet.ServletSecurityProvider;
import org.apache.axis.server.AxisServer;
import org.apache.axis.transport.http.HTTPConstants;
import org.apache.axis.transport.http.ServletEndpointContextImpl;
import org.apache.axis.utils.Admin;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.mule.MuleManager;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.WriterMessageAdapter;
import org.mule.providers.soap.axis.extensions.MuleConfigProvider;
import org.mule.umo.UMOEventContext;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.Callable;
import org.mule.umo.lifecycle.Initialisable;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOMessageAdapter;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AxisServiceComponent
implements Initialisable,
Callable {
    protected static transient Log logger = org.apache.commons.logging.LogFactory.getLog((Class)(class$org$mule$providers$soap$axis$AxisServiceComponent == null ? (class$org$mule$providers$soap$axis$AxisServiceComponent = AxisServiceComponent.class$("org.mule.providers.soap.axis.AxisServiceComponent")) : class$org$mule$providers$soap$axis$AxisServiceComponent));
    private static Log tlog = LogFactory.getLog((String)"org.apache.axis.TIME");
    private static Log exceptionLog = LogFactory.getLog((String)"org.apache.axis.EXCEPTIONS");
    public static final String INIT_PROPERTY_TRANSPORT_NAME = "transport.name";
    public static final String INIT_PROPERTY_USE_SECURITY = "use-servlet-security";
    public static final String INIT_PROPERTY_ENABLE_LIST = "axis.enableListQuery";
    public static final String DEFAULT_AXIS_HOME = "/axisHome";
    private String transportName = "http";
    private ServletSecurityProvider securityProvider = null;
    private static boolean isDebug = true;
    private boolean enableList = true;
    private String homeDir;
    private AxisServer axisServer;
    static /* synthetic */ Class class$org$mule$providers$soap$axis$AxisServiceComponent;

    public Object onCall(UMOEventContext context) throws Exception {
        String method = (String)context.getProperty("http.method", (Object)"GET");
        WriterMessageAdapter response = new WriterMessageAdapter((Object)new StringWriter());
        if ("GET".equals(method.toUpperCase())) {
            this.doGet(context, response);
        } else {
            this.doPost(context, response);
        }
        response.getWriter().close();
        return new MuleMessage((UMOMessageAdapter)response);
    }

    public void initialise() throws InitialisationException {
    }

    public void doGet(UMOEventContext context, WriterMessageAdapter response) throws UMOException, IOException {
        try {
            boolean hasNoPath;
            MuleEndpointURI endpointUri = new MuleEndpointURI("soap:" + context.getEndpointURI().getAddress() + context.getMessageAsString());
            AxisServer engine = this.getAxisServer();
            String pathInfo = endpointUri.getPath();
            boolean wsdlRequested = false;
            boolean listRequested = false;
            if (endpointUri.getAddress().endsWith(".jws")) {
                throw new AxisFault("Jws not supported by the Mule Axis service");
            }
            String queryString = endpointUri.getQuery();
            if (queryString != null) {
                if (queryString.equalsIgnoreCase("wsdl")) {
                    wsdlRequested = true;
                } else if (queryString.equalsIgnoreCase("list")) {
                    listRequested = true;
                }
            }
            boolean bl = hasNoPath = pathInfo == null || pathInfo.equals("") || pathInfo.equals("/");
            if (!wsdlRequested && !listRequested && hasNoPath) {
                this.reportAvailableServices(context, response);
            } else {
                MessageContext msgContext = new MessageContext((AxisEngine)engine);
                this.populateMessageContext(msgContext, context, (UMOEndpointURI)endpointUri);
                msgContext.setProperty("transport.url", (Object)endpointUri.toString());
                if (wsdlRequested) {
                    this.processWsdlRequest(msgContext, response);
                } else if (listRequested) {
                    this.processListRequest(response);
                } else {
                    this.processMethodRequest(msgContext, context, response, (UMOEndpointURI)endpointUri);
                }
            }
        }
        catch (AxisFault fault) {
            this.reportTroubleInGet((Exception)((Object)fault), response);
        }
        catch (Exception e) {
            this.reportTroubleInGet(e, response);
        }
    }

    private void reportTroubleInGet(Exception exception, WriterMessageAdapter response) {
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        response.setProperty((Object)"http.status", (Object)"500");
        response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
        response.write("<p>" + Messages.getMessage((String)"somethingWrong00") + "</p>");
        if (exception instanceof AxisFault) {
            AxisFault fault = (AxisFault)((Object)exception);
            this.processAxisFault(fault);
            this.writeFault(response, fault);
        } else {
            this.logException(exception);
            response.write("<pre>Exception - " + exception + "<br>");
            response.write("</pre>");
        }
    }

    protected void processAxisFault(AxisFault fault) {
        Element runtimeException = fault.lookupFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        if (runtimeException != null) {
            exceptionLog.info((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
            fault.removeFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION);
        } else if (exceptionLog.isDebugEnabled()) {
            exceptionLog.debug((Object)Messages.getMessage((String)"axisFault00"), (Throwable)fault);
        }
    }

    protected void logException(Exception e) {
        exceptionLog.info((Object)Messages.getMessage((String)"exception00"), (Throwable)e);
    }

    private void writeFault(WriterMessageAdapter response, AxisFault axisFault) {
        String localizedMessage = XMLUtils.xmlEncodeString((String)axisFault.getLocalizedMessage());
        response.write("<pre>Fault - " + localizedMessage + "<br>");
        response.write(axisFault.dumpToString());
        response.write("</pre>");
    }

    protected void processMethodRequest(MessageContext msgContext, UMOEventContext context, WriterMessageAdapter response, UMOEndpointURI endpointUri) throws AxisFault {
        Properties params = endpointUri.getUserParams();
        String method = (String)params.remove("method");
        if (method == null) {
            method = endpointUri.getPath().substring(endpointUri.getPath().lastIndexOf("/") + 1);
        }
        StringBuffer args = new StringBuffer();
        Iterator<Map.Entry<Object, Object>> iterator = params.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            args.append("<").append(entry.getKey()).append(">");
            args.append(entry.getValue());
            args.append("</").append(entry.getKey()).append(">");
        }
        if (method == null) {
            response.setProperty((Object)"Content-Type", (Object)"text/html");
            response.setProperty((Object)"http.status", (Object)"400");
            response.write("<h2>" + Messages.getMessage((String)"error00") + ":  " + Messages.getMessage((String)"invokeGet00") + "</h2>");
            response.write("<p>" + Messages.getMessage((String)"noMethod01") + "</p>");
        } else {
            this.invokeEndpointFromGet(msgContext, response, method, args.toString());
        }
    }

    protected void processWsdlRequest(MessageContext msgContext, WriterMessageAdapter response) throws AxisFault {
        AxisServer engine = this.getAxisServer();
        try {
            engine.generateWSDL(msgContext);
            Document doc = (Document)msgContext.getProperty("WSDL");
            if (doc != null) {
                response.setProperty((Object)"Content-Type", (Object)"text/xml");
                XMLUtils.DocumentToWriter((Document)doc, (Writer)response.getWriter());
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"processWsdlRequest: failed to create WSDL");
                }
                this.reportNoWSDL(response, "noWSDL02", null);
            }
        }
        catch (AxisFault axisFault) {
            if (axisFault.getFaultCode().equals(Constants.QNAME_NO_SERVICE_FAULT_CODE)) {
                this.processAxisFault(axisFault);
                response.setProperty((Object)"http.status", (Object)"404");
                this.reportNoWSDL(response, "noWSDL01", axisFault);
            }
            throw axisFault;
        }
    }

    protected void invokeEndpointFromGet(MessageContext msgContext, WriterMessageAdapter response, String method, String args) throws AxisFault {
        String body = "<" + method + ">" + args + "</" + method + ">";
        String msgtxt = "<SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\"><SOAP-ENV:Body>" + body + "</SOAP-ENV:Body>" + "</SOAP-ENV:Envelope>";
        Message responseMsg = null;
        try {
            ByteArrayInputStream istream = new ByteArrayInputStream(msgtxt.getBytes("ISO-8859-1"));
            AxisServer engine = this.getAxisServer();
            Message msg = new Message((Object)istream, false);
            msgContext.setRequestMessage(msg);
            engine.invoke(msgContext);
            responseMsg = msgContext.getResponseMessage();
            response.setProperty((Object)"Cache-Control", (Object)"no-cache");
            response.setProperty((Object)"Pragma", (Object)"no-cache");
            if (responseMsg == null) {
                throw new Exception(Messages.getMessage((String)"noResponse01"));
            }
        }
        catch (AxisFault fault) {
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(response, fault);
            if (responseMsg == null) {
                responseMsg = new Message((Object)fault);
            }
        }
        catch (Exception e) {
            response.setProperty((Object)"http.status", (Object)"500");
            responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
        }
        response.setProperty((Object)"Content-Type", (Object)"text/xml");
        response.write(responseMsg.getSOAPPartAsString());
    }

    protected void reportServiceInfo(WriterMessageAdapter response, SOAPService service, String serviceName) {
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        response.write("<h1>" + service.getName() + "</h1>");
        response.write("<p>" + Messages.getMessage((String)"axisService00") + "</p>");
        response.write("<i>" + Messages.getMessage((String)"perhaps00") + "</i>");
    }

    protected void processListRequest(WriterMessageAdapter response) throws AxisFault {
        AxisServer engine = this.getAxisServer();
        if (this.enableList) {
            Document doc = Admin.listConfig((AxisEngine)engine);
            if (doc != null) {
                response.setProperty((Object)"Content-Type", (Object)"text/xml");
                XMLUtils.DocumentToWriter((Document)doc, (Writer)response.getWriter());
            } else {
                response.setProperty((Object)"http.status", (Object)"404");
                response.setProperty((Object)"Content-Type", (Object)"text/html");
                response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
                response.write("<p>" + Messages.getMessage((String)"noDeploy00") + "</p>");
            }
        } else {
            response.setProperty((Object)"http.status", (Object)"403");
            response.setProperty((Object)"Content-Type", (Object)"text/html");
            response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
            response.write("<p><i>?list</i> " + Messages.getMessage((String)"disabled00") + "</p>");
        }
    }

    protected void reportNoWSDL(WriterMessageAdapter response, String moreDetailCode, AxisFault axisFault) {
        response.setProperty((Object)"http.status", (Object)"404");
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
        response.write("<p>" + Messages.getMessage((String)"noWSDL00") + "</p>");
        if (moreDetailCode != null) {
            response.write("<p>" + Messages.getMessage((String)moreDetailCode) + "</p>");
        }
    }

    protected void reportAvailableServices(UMOEventContext context, WriterMessageAdapter response) throws ConfigurationException, AxisFault {
        AxisServer engine = this.getAxisServer();
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        response.write("<h2>And now... Some Services</h2>");
        String version = MuleManager.getConfiguration().getProductVersion();
        if (version == null) {
            version = "Version Not Set";
        }
        response.write("<h5>(Mule - " + version + ")</h5>");
        try {
            response.write("<table width=\"400\"><tr><th>Mule Component Services</th><th>Axis Services</th></tr><tr><td width=\"200\" valign=\"top\">");
            Iterator i = engine.getConfig().getDeployedServices();
            this.listServices(i, response);
            response.write("</td><td width=\"200\" valign=\"top\">");
            i = ((MuleConfigProvider)engine.getConfig()).getAxisDeployedServices();
            this.listServices(i, response);
            response.write("</td></tr></table>");
        }
        catch (ConfigurationException configException) {
            if (configException.getContainedException() instanceof AxisFault) {
                throw (AxisFault)((Object)configException.getContainedException());
            }
            throw configException;
        }
    }

    private void listServices(Iterator i, WriterMessageAdapter response) {
        response.write("<ul>");
        while (i.hasNext()) {
            ArrayList operations;
            ServiceDesc sd = (ServiceDesc)i.next();
            StringBuffer sb = new StringBuffer();
            sb.append("<li>");
            String name = sd.getName();
            sb.append(name);
            sb.append(" <a href=\"");
            if (sd.getEndpointURL() != null) {
                sb.append(sd.getEndpointURL());
                if (!sd.getEndpointURL().endsWith("/")) {
                    sb.append("/");
                }
            }
            sb.append(name);
            sb.append("?wsdl\"><i>(wsdl)</i></a></li>");
            response.write(sb.toString());
            if (sd.getDocumentation() != null) {
                response.write("<ul><h6>" + sd.getDocumentation() + "</h6></ul>");
            }
            if ((operations = sd.getOperations()).isEmpty()) continue;
            response.write("<ul>");
            Iterator it = operations.iterator();
            while (it.hasNext()) {
                OperationDesc desc = (OperationDesc)it.next();
                response.write("<li>" + desc.getName());
            }
            response.write("</ul>");
        }
        response.write("</ul>");
    }

    protected void reportCantGetAxisService(UMOEventContext context, WriterMessageAdapter response) {
        response.setProperty((Object)"http.status", (Object)"404");
        response.setProperty((Object)"Content-Type", (Object)"text/html");
        response.write("<h2>" + Messages.getMessage((String)"error00") + "</h2>");
        response.write("<p>" + Messages.getMessage((String)"noService06") + "</p>");
    }

    public void doPost(UMOEventContext context, WriterMessageAdapter response) throws ServletException, IOException {
        long t0 = 0L;
        long t1 = 0L;
        long t2 = 0L;
        long t3 = 0L;
        long t4 = 0L;
        String soapAction = null;
        AxisServer engine = this.getAxisServer();
        if (engine == null) {
            ServletException se = new ServletException(Messages.getMessage((String)"noEngine00"));
            logger.debug((Object)"No Engine!", (Throwable)se);
            throw se;
        }
        MessageContext msgContext = new MessageContext((AxisEngine)engine);
        if (isDebug) {
            logger.debug((Object)"Enter: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t0 = System.currentTimeMillis();
        }
        Message responseMsg = null;
        String contentType = null;
        try {
            UMOEndpointURI endpointUri = this.getEndpoint(context);
            this.populateMessageContext(msgContext, context, endpointUri);
            if (this.securityProvider != null) {
                if (isDebug) {
                    logger.debug((Object)("securityProvider:" + this.securityProvider));
                }
                msgContext.setProperty("securityProvider", (Object)this.securityProvider);
            }
            Message requestMsg = new Message((Object)context.getTransformedMessageAsString(), false, (String)context.getProperty("Content-Type"), (String)context.getProperty("Content-Location"));
            if (isDebug) {
                logger.debug((Object)("Request Message:" + requestMsg));
            }
            msgContext.setRequestMessage(requestMsg);
            msgContext.setProperty("transport.url", (Object)endpointUri.toString());
            soapAction = this.getSoapAction(context);
            if (soapAction != null) {
                msgContext.setUseSOAPAction(true);
                msgContext.setSOAPActionURI(soapAction);
            }
            if (tlog.isDebugEnabled()) {
                t1 = System.currentTimeMillis();
            }
            if (isDebug) {
                logger.debug((Object)"Invoking Axis Engine.");
            }
            engine.invoke(msgContext);
            if (isDebug) {
                logger.debug((Object)"Return from Axis Engine.");
            }
            if (tlog.isDebugEnabled()) {
                t2 = System.currentTimeMillis();
            }
            if ((responseMsg = msgContext.getResponseMessage()) == null) {
                throw new Exception(Messages.getMessage((String)"noResponse01"));
            }
        }
        catch (AxisFault fault) {
            this.processAxisFault(fault);
            this.configureResponseFromAxisFault(response, fault);
            responseMsg = msgContext.getResponseMessage();
            if (responseMsg == null) {
                responseMsg = new Message((Object)fault);
            }
        }
        catch (Exception e) {
            responseMsg = msgContext.getResponseMessage();
            response.setProperty((Object)"http.status", (Object)"500");
            responseMsg = this.convertExceptionToAxisFault(e, responseMsg);
        }
        contentType = responseMsg.getContentType(msgContext.getSOAPConstants());
        if (tlog.isDebugEnabled()) {
            t3 = System.currentTimeMillis();
        }
        if (responseMsg != null) {
            this.sendResponse((String)context.getProperty("http.status"), contentType, response, responseMsg);
        }
        if (isDebug) {
            logger.debug((Object)"Response sent.");
            logger.debug((Object)"Exit: doPost()");
        }
        if (tlog.isDebugEnabled()) {
            t4 = System.currentTimeMillis();
            tlog.debug((Object)("axisServlet.doPost: " + soapAction + " pre=" + (t1 - t0) + " invoke=" + (t2 - t1) + " post=" + (t3 - t2) + " send=" + (t4 - t3) + " " + msgContext.getTargetService() + "." + (msgContext.getOperation() != null ? msgContext.getOperation().getName() : "")));
        }
    }

    private UMOEndpointURI getEndpoint(UMOEventContext context) throws MalformedEndpointException {
        String endpoint = context.getEndpointURI().getAddress();
        String request = (String)context.getProperty("http.request");
        if (request != null) {
            int i = endpoint.indexOf("/", endpoint.indexOf("://") + 3);
            if (i > -1) {
                endpoint = endpoint.substring(0, i);
            }
            endpoint = endpoint + request;
            return new MuleEndpointURI(endpoint);
        }
        return context.getEndpointURI();
    }

    private void configureResponseFromAxisFault(WriterMessageAdapter response, AxisFault fault) {
        int status = this.getHttpResponseStatus(fault);
        if (status == 401) {
            response.setProperty((Object)"WWW-Authenticate", (Object)"Basic realm=\"AXIS\"");
        }
        response.setProperty((Object)"http.status", (Object)String.valueOf(status));
    }

    private Message convertExceptionToAxisFault(Exception exception, Message responseMsg) {
        this.logException(exception);
        if (responseMsg == null) {
            AxisFault fault = AxisFault.makeFault((Exception)exception);
            this.processAxisFault(fault);
            responseMsg = new Message((Object)fault);
        }
        return responseMsg;
    }

    protected int getHttpResponseStatus(AxisFault af) {
        return af.getFaultCode().getLocalPart().startsWith("Server.Unauth") ? 401 : 500;
    }

    private void sendResponse(String clientVersion, String contentType, WriterMessageAdapter response, Message responseMsg) throws AxisFault, IOException {
        if (responseMsg == null) {
            response.setProperty((Object)"http.status", (Object)"204");
            if (isDebug) {
                logger.debug((Object)"NO AXIS MESSAGE TO RETURN!");
            }
        } else {
            if (isDebug) {
                logger.debug((Object)("Returned Content-Type:" + contentType));
            }
            try {
                response.setProperty((Object)"Content-Type", (Object)contentType);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                responseMsg.writeTo((OutputStream)baos);
                response.write(baos.toString());
            }
            catch (SOAPException e) {
                this.logException((Exception)((Object)e));
            }
        }
    }

    private void populateMessageContext(MessageContext msgContext, UMOEventContext context, UMOEndpointURI endpointUri) throws AxisFault, ConfigurationException {
        if (isDebug) {
            logger.debug((Object)("MessageContext:" + msgContext));
            logger.debug((Object)("HEADER_CONTENT_TYPE:" + context.getProperty("Content-Type")));
            logger.debug((Object)("HEADER_CONTENT_LOCATION:" + context.getProperty("Content-Location")));
            logger.debug((Object)("Constants.MC_HOME_DIR:" + String.valueOf(this.getHomeDir())));
            logger.debug((Object)("Constants.MC_RELATIVE_PATH:" + endpointUri.getPath()));
            logger.debug((Object)("HTTPConstants.HEADER_AUTHORIZATION:" + context.getProperty("Authorization")));
            logger.debug((Object)("Constants.MC_REMOTE_ADDR:" + endpointUri.getHost()));
        }
        msgContext.setTransportName(this.transportName);
        msgContext.setProperty("home.dir", (Object)this.getHomeDir());
        msgContext.setProperty("path", (Object)endpointUri.getPath());
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLET, (Object)this);
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETLOCATION, (Object)endpointUri.getPath());
        String serviceName = this.getServiceName(context, endpointUri);
        SOAPService service = msgContext.getAxisEngine().getConfig().getService(new QName(serviceName.substring(1)));
        if (service.getOption("componentName") != null) {
            String servicePath = (String)service.getOption("servicePath");
            if (!endpointUri.getPath().startsWith(servicePath + serviceName)) {
                throw new AxisFault("Failed to find service: " + endpointUri.getPath());
            }
        }
        msgContext.setProperty(HTTPConstants.MC_HTTP_SERVLETPATHINFO, (Object)serviceName);
        msgContext.setProperty("serviceName", (Object)serviceName);
        msgContext.setProperty("Authorization", context.getProperty("Authorization"));
        msgContext.setProperty("remoteaddr", (Object)endpointUri.getHost());
        ServletEndpointContextImpl sec = new ServletEndpointContextImpl();
        msgContext.setProperty("servletEndpointContext", (Object)sec);
    }

    private String getSoapAction(UMOEventContext context) throws AxisFault {
        String soapAction = (String)context.getProperty("SOAPAction");
        if (isDebug) {
            logger.debug((Object)("HEADER_SOAP_ACTION:" + soapAction));
        }
        if (soapAction == null) {
            AxisFault af = new AxisFault("Client.NoSOAPAction", Messages.getMessage((String)"noHeader00", (String)"SOAPAction"), null, null);
            exceptionLog.error((Object)Messages.getMessage((String)"genFault00"), (Throwable)af);
            throw af;
        }
        if (soapAction.length() == 0) {
            soapAction = context.getEndpointURI().getAddress();
        }
        return soapAction;
    }

    protected String getServiceName(UMOEventContext context, UMOEndpointURI endpointUri) throws AxisFault {
        int i;
        String serviceName = endpointUri.getPath();
        if (serviceName == null || serviceName.length() == 0) {
            serviceName = this.getSoapAction(context);
            serviceName = serviceName.replaceAll("\"", "");
            serviceName = serviceName.substring(serviceName.indexOf("/", serviceName.indexOf("//") + 2));
        }
        if ((i = serviceName.lastIndexOf("/")) > -1) {
            serviceName = serviceName.substring(i);
        }
        return serviceName;
    }

    protected String getProtocolVersion(HttpServletRequest req) {
        String ver;
        int sindex;
        String ret = HTTPConstants.HEADER_PROTOCOL_V10;
        String prot = req.getProtocol();
        if (prot != null && -1 != (sindex = prot.indexOf(47)) && HTTPConstants.HEADER_PROTOCOL_V11.equals((ver = prot.substring(sindex + 1)).trim())) {
            ret = HTTPConstants.HEADER_PROTOCOL_V11;
        }
        return ret;
    }

    public String getTransportName() {
        return this.transportName;
    }

    public void setTransportName(String transportName) {
        this.transportName = transportName;
    }

    public boolean isEnableList() {
        return this.enableList;
    }

    public void setEnableList(boolean enableList) {
        this.enableList = enableList;
    }

    public String getHomeDir() {
        if (this.homeDir == null) {
            this.homeDir = MuleManager.getConfiguration().getWorkingDirectoy() + DEFAULT_AXIS_HOME;
        }
        return this.homeDir;
    }

    public void setHomeDir(String homeDir) {
        this.homeDir = homeDir;
    }

    public AxisServer getAxisServer() {
        return this.axisServer;
    }

    public void setAxisServer(AxisServer axisServer) {
        this.axisServer = axisServer;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

