/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPHeaderElement;
import org.apache.axis.MessageContext;
import org.apache.axis.encoding.Base64;
import org.apache.axis.message.MessageElement;
import org.apache.axis.utils.XMLUtils;
import org.mule.umo.UMOEvent;

public class MuleSoapHeaders {
    private String replyTo;
    private String correlationId;
    private String correlationGroup;
    private String correlationSequence;
    public static final String MULE_10_ACTOR = "http://www.muleumo.org/providers/soap/1.0";
    public static final String MULE_NAMESPACE = "mule";
    public static final String MULE_HEADER = "header";
    public static final String ENV_REQUEST_HEADERS = "MULE_REQUEST_HEADERS";

    public MuleSoapHeaders(UMOEvent event) {
        this.setCorrelationId(event.getMessage().getCorrelationId());
        this.setCorrelationGroup(String.valueOf(event.getMessage().getCorrelationGroupSize()));
        this.setCorrelationSequence(String.valueOf(event.getMessage().getCorrelationSequence()));
        this.setReplyTo((String)event.getMessage().getReplyTo());
    }

    public MuleSoapHeaders(SOAPHeader soapHeader) throws SOAPException {
        Iterator iter = soapHeader.examineHeaderElements(MULE_10_ACTOR);
        while (iter.hasNext()) {
            SOAPHeaderElement header = (SOAPHeaderElement)iter.next();
            Iterator iter2 = header.getChildElements();
            while (iter2.hasNext()) {
                SOAPElement element = (SOAPElement)iter2.next();
                if ("MULE_CORRELATION_ID".equals(element.getElementName().getLocalName())) {
                    this.correlationId = this.getStringValue(element);
                    continue;
                }
                if ("MULE_CORRELATION_GROUP".equals(element.getElementName().getLocalName())) {
                    this.correlationGroup = this.getStringValue(element);
                    continue;
                }
                if ("MULE_CORRELATION_SEQUENCE".equals(element.getElementName().getLocalName())) {
                    this.correlationSequence = this.getStringValue(element);
                    continue;
                }
                if ("MULE_REPLYTO".equals(element.getElementName().getLocalName())) {
                    this.replyTo = this.getStringValue(element);
                    continue;
                }
                throw new SOAPException("Unrecognised Mule Soap header: " + element.getElementName().getQualifiedName());
            }
        }
    }

    private String getStringValue(SOAPElement e) {
        String value = e.getValue();
        if (value == null && e.hasChildNodes() && (value = e.getChildNodes().item(0).getChildNodes().item(0).getNodeValue()) != null) {
            value = new String(Base64.decode((String)value));
        }
        return value;
    }

    public void setAsClientProperties(MessageContext context) {
        if (this.correlationId != null) {
            context.setProperty("MULE_CORRELATION_ID", (Object)this.correlationId);
        }
        if (this.correlationGroup != null) {
            context.setProperty("MULE_CORRELATION_GROUP", (Object)this.correlationGroup);
        }
        if (this.correlationSequence != null) {
            context.setProperty("MULE_CORRELATION_SEQUENCE", (Object)this.correlationSequence);
        }
        if (this.replyTo != null) {
            context.setProperty("MULE_REPLYTO", (Object)this.replyTo);
        }
    }

    public void addHeaders(SOAPEnvelope env) throws SOAPException {
        MessageElement e;
        SOAPHeader header = env.getHeader();
        if (this.correlationId != null || this.replyTo != null) {
            if (header == null) {
                header = env.addHeader();
            }
        } else {
            return;
        }
        Name muleHeaderName = env.createName(MULE_HEADER, MULE_NAMESPACE, MULE_10_ACTOR);
        SOAPHeaderElement muleHeader = header.addHeaderElement(muleHeaderName);
        muleHeader.setActor(MULE_10_ACTOR);
        if (this.correlationId != null) {
            e = (MessageElement)muleHeader.addChildElement("MULE_CORRELATION_ID", MULE_NAMESPACE);
            e.setObjectValue((Object)this.correlationId);
            e = (MessageElement)muleHeader.addChildElement("MULE_CORRELATION_GROUP", MULE_NAMESPACE);
            e.setObjectValue((Object)this.correlationGroup);
            e = (MessageElement)muleHeader.addChildElement("MULE_CORRELATION_SEQUENCE", MULE_NAMESPACE);
            e.setObjectValue((Object)this.correlationSequence);
        }
        if (this.replyTo != null) {
            e = (MessageElement)muleHeader.addChildElement("MULE_REPLYTO", MULE_NAMESPACE);
            String enc = XMLUtils.xmlEncodeString((String)this.replyTo);
            e.setObjectValue((Object)enc);
        }
    }

    public String getReplyTo() {
        return this.replyTo;
    }

    public void setReplyTo(String replyTo) {
        this.replyTo = replyTo;
    }

    public String getCorrelationId() {
        return this.correlationId;
    }

    public void setCorrelationId(String correlationId) {
        this.correlationId = correlationId;
    }

    public String getCorrelationGroup() {
        return this.correlationGroup;
    }

    public void setCorrelationGroup(String correlationGroup) {
        this.correlationGroup = correlationGroup;
    }

    public String getCorrelationSequence() {
        return this.correlationSequence;
    }

    public void setCorrelationSequence(String correlationSequence) {
        this.correlationSequence = correlationSequence;
    }
}

