/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.glue;

import electric.server.http.HTTP;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.soap.glue.GlueMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.lifecycle.LifecycleException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class GlueConnector
extends AbstractServiceEnabledConnector {
    private List serverEndpoints = new ArrayList();
    private Map context;

    public String getProtocol() {
        return "glue";
    }

    protected void stopConnector() throws UMOException {
        String endpoint = null;
        try {
            Iterator iterator = this.serverEndpoints.iterator();
            while (iterator.hasNext()) {
                endpoint = (String)iterator.next();
                HTTP.shutdown((String)endpoint);
            }
            this.serverEndpoints.clear();
        }
        catch (IOException e) {
            throw new LifecycleException(new Message("soap", 1, endpoint), (Throwable)e, (Object)this);
        }
    }

    public UMOMessageReceiver registerListener(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint == null || component == null) {
            throw new IllegalArgumentException("The endpoint and component cannot be null when registering a listener");
        }
        if (endpoint.getEndpointURI() == null) {
            throw new InitialisationException(new Message(34), (Object)this);
        }
        GlueMessageReceiver receiver = null;
        this.logger.info((Object)("registering listener: " + component.getDescriptor().getName() + " on endpointUri: " + endpoint.getEndpointURI().getAddress()));
        if (this.shouldCreateServer(endpoint.getEndpointURI().getAddress())) {
            receiver = new GlueMessageReceiver((UMOConnector)this, component, endpoint, true);
            this.receivers.put((Object)endpoint.getEndpointURI().getAddress(), (Object)receiver);
            this.serverEndpoints.add(endpoint.getEndpointURI().getAddress());
        } else {
            receiver = new GlueMessageReceiver((UMOConnector)this, component, endpoint, false);
            this.receivers.put((Object)(endpoint.getEndpointURI().getAddress() + "/" + component.getDescriptor().getName()), (Object)receiver);
        }
        return receiver;
    }

    private boolean shouldCreateServer(String endpoint) throws URISyntaxException {
        URI uri = new URI(endpoint);
        String ep = uri.getScheme() + "://" + uri.getHost();
        if (uri.getPort() != -1) {
            ep = ep + ":" + uri.getPort();
        }
        Iterator iterator = this.serverEndpoints.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (!s.startsWith(ep)) continue;
            return false;
        }
        return true;
    }

    public Map getContext() {
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }
}

