/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.glue;

import electric.glue.context.ThreadContext;
import electric.proxy.IProxy;
import electric.registry.Registry;
import java.util.Properties;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.ReceiveException;

public class GlueMessageDispatcher
extends AbstractMessageDispatcher {
    public GlueMessageDispatcher(AbstractConnector connector) {
        super(connector);
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.doSend(event);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String method = (String)endpointUri.getParams().remove("method");
        this.setContext(event);
        IProxy proxy = null;
        String bindService = endpointUri.getAddress();
        if (bindService.indexOf(".wsdl") == -1) {
            bindService = bindService.replaceAll("/" + method, ".wsdl/" + method);
        }
        proxy = Registry.bind((String)bindService);
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        if (event.getMessage().getReplyTo() != null) {
            ThreadContext.setProperty((String)"MULE_REPLYTO", (Object)event.getMessage().getReplyTo());
        }
        if (event.getMessage().getCorrelationId() != null) {
            ThreadContext.setProperty((String)"MULE_CORRELATION_ID", (Object)event.getMessage().getCorrelationId());
        }
        try {
            Object result = proxy.invoke(method, args);
            if (result == null) {
                return null;
            }
            return new MuleMessage(result, null);
        }
        catch (Throwable t) {
            throw new DispatchException(event.getMessage(), event.getEndpoint(), t);
        }
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        MuleEndpointURI ep = new MuleEndpointURI(endpointUri);
        Properties params = ep.getParams();
        String method = (String)params.remove("method");
        IProxy proxy = Registry.bind((String)ep.getAddress());
        try {
            Object result = proxy.invoke(method, params.values().toArray());
            return new MuleMessage(result, null);
        }
        catch (Throwable t) {
            throw new ReceiveException(endpointUri, timeout, t);
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public void doDispose() {
    }

    protected String getMethod(String endpoint) throws MalformedEndpointException {
        int i = endpoint.lastIndexOf("/");
        String method = endpoint.substring(i + 1);
        if (method.indexOf(".wsdl") != -1) {
            throw new MalformedEndpointException("Soap url must contain method to invoke as a param [method=X] or as the last path element");
        }
        return method;
    }

    protected void setContext(UMOEvent event) {
        int value;
        Object replyTo = event.getMessage().getReplyTo();
        if (replyTo != null) {
            ThreadContext.setProperty((String)"MULE_REPLYTO", (Object)replyTo);
        }
        String correlationId = event.getMessage().getCorrelationId();
        if (replyTo != null) {
            ThreadContext.setProperty((String)"MULE_CORRELATION_ID", (Object)correlationId);
        }
        if ((value = event.getMessage().getCorrelationSequence()) > 0) {
            ThreadContext.setProperty((String)"MULE_CORRELATION_SEQUENCE", (Object)String.valueOf(value));
        }
        if ((value = event.getMessage().getCorrelationGroupSize()) > 0) {
            ThreadContext.setProperty((String)"MULE_CORRELATION_GROUP", (Object)String.valueOf(value));
        }
    }
}

