/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import javax.xml.soap.SOAPException;
import org.apache.axis.MessageContext;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.soap.axis.MuleSoapHeaders;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.transformer.UMOTransformer;

public class AxisMessageAdapter
extends AbstractMessageAdapter {
    private Object message;
    private UMOTransformer trans = new SerializableToByteArray();

    public AxisMessageAdapter(Object message) throws MessagingException {
        this.message = message;
        try {
            MessageContext ctx = MessageContext.getCurrentContext();
            if (ctx != null) {
                MuleSoapHeaders header = new MuleSoapHeaders(ctx.getMessage().getSOAPPart().getEnvelope().getHeader());
                if (header.getReplyTo() != null && !"".equals(header.getReplyTo())) {
                    this.setReplyTo(header.getReplyTo());
                }
                if (header.getCorrelationGroup() != null && !"".equals(header.getCorrelationGroup()) && !"-1".equals(header.getCorrelationGroup())) {
                    this.setCorrelationGroupSize(Integer.parseInt(header.getCorrelationGroup()));
                }
                if (header.getCorrelationSequence() != null && !"".equals(header.getCorrelationSequence()) && !"-1".equals(header.getCorrelationSequence())) {
                    this.setCorrelationSequence(Integer.parseInt(header.getCorrelationSequence()));
                }
                if (header.getCorrelationId() != null && !"".equals(header.getCorrelationId())) {
                    this.setCorrelationId(header.getCorrelationId());
                }
            }
        }
        catch (SOAPException e) {
            throw new MessagingException(new Message("soap", 5), message, (Throwable)e);
        }
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.getPayloadAsBytes());
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return (byte[])this.trans.transform(this.message);
    }

    public Object getPayload() {
        return this.message;
    }
}

