/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.DeserializerFactory;
import javax.xml.rpc.encoding.SerializerFactory;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.Handler;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.description.ServiceDesc;
import org.apache.axis.encoding.TypeMappingRegistryImpl;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.wsdl.fromJava.Namespaces;
import org.apache.axis.wsdl.fromJava.Types;
import org.mule.config.i18n.Message;
import org.mule.impl.InitialisationCallback;
import org.mule.impl.MuleDescriptor;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.AxisInitialisationCallback;
import org.mule.providers.soap.axis.extensions.MuleProvider;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassHelper;

public class AxisMessageReceiver
extends AbstractMessageReceiver {
    protected AxisConnector connector;
    protected SOAPService service;

    public AxisMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
        this.connector = (AxisConnector)connector;
        try {
            this.init();
        }
        catch (Exception e) {
            throw new InitialisationException((Throwable)e, (Object)this);
        }
    }

    protected void init() throws Exception {
        Class[] interfaces;
        this.service = new SOAPService((Handler)new MuleProvider(this.connector));
        MuleDescriptor descriptor = (MuleDescriptor)this.component.getDescriptor();
        this.service.setEngine((AxisEngine)this.connector.getAxisServer());
        UMOEndpointURI uri = this.endpoint.getEndpointURI();
        String serviceName = this.component.getDescriptor().getName();
        String servicePath = uri.getPath();
        this.service.setOption(serviceName, (Object)this);
        this.service.setOption("servicePath", (Object)servicePath);
        this.service.setOption("componentName", (Object)serviceName);
        this.service.setName(serviceName);
        Map options = (Map)descriptor.getProperties().get("axisOptions");
        if (options != null) {
            Iterator iterator = options.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.service.setOption(entry.getKey().toString(), entry.getValue());
                this.logger.debug((Object)("Adding Axis option: " + entry));
            }
        }
        if ((interfaces = ServiceProxy.getInterfacesForComponent(this.component)).length == 0) {
            throw new InitialisationException(new Message(160, (Object)serviceName), (Object)this.component);
        }
        String methodNames = "*";
        String[] methods = ServiceProxy.getMethodNames(interfaces);
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < methods.length; ++i) {
            buf.append(methods[i]).append(",");
        }
        String className = interfaces[0].getName();
        methodNames = buf.toString();
        methodNames = methodNames.substring(0, methodNames.length() - 1);
        String namespace = Namespaces.makeNamespace((String)className);
        this.setOptionIfNotset(this.service, "wsdlServicePort", serviceName);
        this.setOptionIfNotset(this.service, "className", className);
        this.setOptionIfNotset(this.service, "scope", "Request");
        this.setOptionIfNotset(this.service, "wsdlTargetNamespace", namespace);
        if (methodNames == null) {
            this.setOptionIfNotset(this.service, "allowedMethods", "*");
        } else {
            this.setOptionIfNotset(this.service, "allowedMethods", methodNames);
        }
        ServiceDesc sd = this.service.getInitializedServiceDesc(null);
        sd.setName(serviceName);
        sd.setEndpointURL(uri.getAddress() + "/" + serviceName);
        String style = (String)descriptor.getProperties().get("style");
        String use = (String)descriptor.getProperties().get("use");
        String doc = (String)descriptor.getProperties().get("documentation");
        if (style != null) {
            sd.setStyle(Style.getStyle((String)style));
        }
        if (use != null) {
            sd.setUse(Use.getUse((String)use));
        }
        sd.setDocumentation(doc);
        TypeMappingRegistryImpl registry = (TypeMappingRegistryImpl)this.service.getTypeMappingRegistry();
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)"true");
        List types = (List)descriptor.getProperties().get("beanTypes");
        this.registerTypes(registry, types);
        this.registerTypes(registry, this.connector.getBeanTypes());
        this.service.setName(serviceName);
        this.service.stop();
        descriptor.addInitialisationCallback((InitialisationCallback)new AxisInitialisationCallback(this.service));
    }

    public void doConnect() throws Exception {
        this.connector.getServerProvider().deployService(this.service.getName(), this.service);
        this.connector.registerReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doDisconnect() throws Exception {
        try {
            this.doStop();
        }
        catch (UMOException e) {
            this.logger.error((Object)e.getMessage(), (Throwable)e);
        }
        this.connector.unregisterReceiverWithMuleService((UMOMessageReceiver)this, this.endpoint.getEndpointURI());
    }

    public void doStart() throws UMOException {
        if (this.service != null) {
            this.service.start();
        }
    }

    public void doStop() throws UMOException {
        if (this.service != null) {
            this.service.stop();
        }
    }

    protected void setOptionIfNotset(SOAPService service, String option, Object value) {
        Object val = service.getOption(option);
        if (val == null) {
            service.setOption(option, value);
        }
    }

    protected void registerTypes(TypeMappingRegistryImpl registry, List types) throws ClassNotFoundException {
        if (types != null) {
            Iterator iterator = types.iterator();
            while (iterator.hasNext()) {
                Class clazz = ClassHelper.loadClass((String)iterator.next().toString(), ((Object)((Object)this)).getClass());
                QName xmlType = new QName(Namespaces.makeNamespace((String)clazz.getName()), Types.getLocalNameFromFullName((String)clazz.getName()));
                registry.getDefaultTypeMapping().register(clazz, xmlType, (SerializerFactory)new BeanSerializerFactory(clazz, xmlType), (DeserializerFactory)new BeanDeserializerFactory(clazz, xmlType));
            }
        }
    }
}

