/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.client.Call;
import org.apache.axis.configuration.FileProvider;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.deployment.wsdd.WSDDProvider;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.server.AxisServer;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.ImmutableMuleEndpoint;
import org.mule.impl.MuleDescriptor;
import org.mule.impl.endpoint.MuleEndpoint;
import org.mule.impl.internal.events.ModelEventListener;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.http.servlet.ServletConnector;
import org.mule.providers.service.ConnectorFactory;
import org.mule.providers.soap.axis.extensions.MuleConfigProvider;
import org.mule.providers.soap.axis.extensions.WSDDJavaMuleProvider;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMODescriptor;
import org.mule.umo.UMOException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.manager.UMOServerEvent;
import org.mule.umo.manager.UMOServerEventListener;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassHelper;

public class AxisConnector
extends AbstractServiceEnabledConnector
implements ModelEventListener {
    public static final QName QNAME_MULERPC_PROVIDER = new QName("http://xml.apache.org/axis/wsdd/providers/java", "Mule");
    public static final QName QNAME_MULE_TYPE_MAPPINGS = new QName("http://www.muleumo.org/ws/mappings", "Mule");
    public static final String DEFAULT_MULE_NAMESPACE_URI = "http://www.muleumo.org";
    public static final String DEFAULT_MULE_AXIS_SERVER_CONFIG = "mule-axis-server-config.wsdd";
    public static final String DEFAULT_MULE_AXIS_CLIENT_CONFIG = "mule-axis-client-config.wsdd";
    public static final String AXIS_SERVICE_COMPONENT_NAME = "_axisServiceComponent";
    public static final String METHOD_NAMESPACE_PROPERTY = "methodNamespace";
    public static final String SERVICE_PROPERTY_COMPONENT_NAME = "componentName";
    public static final String SERVICE_PROPERTY_SERVCE_PATH = "servicePath";
    public static final String ENDPOINT_COUNTERS_PROPERTY = "endpointCounters";
    public static final String WSDL_URL_PROPERTY = "wsdlUrl";
    private String serverConfig;
    private AxisServer axisServer;
    private SimpleProvider serverProvider;
    private String clientConfig;
    private SimpleProvider clientProvider;
    private List beanTypes;
    private MuleDescriptor axisDescriptor;
    private Map axisTransportProtocols;
    private List servletServices = new ArrayList();
    static /* synthetic */ Class class$org$mule$providers$soap$axis$extensions$MuleTransport;
    static /* synthetic */ Class class$org$mule$providers$soap$axis$AxisServiceComponent;

    public AxisConnector() {
        System.setProperty("java.protocol.handler.pkgs", "org.mule.providers.soap.axis.transport|");
        this.axisTransportProtocols = new HashMap();
        this.axisTransportProtocols.put("https", class$org$mule$providers$soap$axis$extensions$MuleTransport == null ? (class$org$mule$providers$soap$axis$extensions$MuleTransport = AxisConnector.class$("org.mule.providers.soap.axis.extensions.MuleTransport")) : class$org$mule$providers$soap$axis$extensions$MuleTransport);
        this.axisTransportProtocols.put("http", class$org$mule$providers$soap$axis$extensions$MuleTransport == null ? (class$org$mule$providers$soap$axis$extensions$MuleTransport = AxisConnector.class$("org.mule.providers.soap.axis.extensions.MuleTransport")) : class$org$mule$providers$soap$axis$extensions$MuleTransport);
        this.axisTransportProtocols.put("smtp", class$org$mule$providers$soap$axis$extensions$MuleTransport == null ? (class$org$mule$providers$soap$axis$extensions$MuleTransport = AxisConnector.class$("org.mule.providers.soap.axis.extensions.MuleTransport")) : class$org$mule$providers$soap$axis$extensions$MuleTransport);
        this.axisTransportProtocols.put("pop3", class$org$mule$providers$soap$axis$extensions$MuleTransport == null ? (class$org$mule$providers$soap$axis$extensions$MuleTransport = AxisConnector.class$("org.mule.providers.soap.axis.extensions.MuleTransport")) : class$org$mule$providers$soap$axis$extensions$MuleTransport);
        this.axisTransportProtocols.put("jms", class$org$mule$providers$soap$axis$extensions$MuleTransport == null ? (class$org$mule$providers$soap$axis$extensions$MuleTransport = AxisConnector.class$("org.mule.providers.soap.axis.extensions.MuleTransport")) : class$org$mule$providers$soap$axis$extensions$MuleTransport);
        this.axisTransportProtocols.put("vm", class$org$mule$providers$soap$axis$extensions$MuleTransport == null ? (class$org$mule$providers$soap$axis$extensions$MuleTransport = AxisConnector.class$("org.mule.providers.soap.axis.extensions.MuleTransport")) : class$org$mule$providers$soap$axis$extensions$MuleTransport);
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        MuleManager.getInstance().registerListener((UMOServerEventListener)this);
        if (this.serverConfig == null) {
            this.serverConfig = DEFAULT_MULE_AXIS_SERVER_CONFIG;
        }
        if (this.clientConfig == null) {
            this.clientConfig = DEFAULT_MULE_AXIS_CLIENT_CONFIG;
        }
        this.serverProvider = this.createAxisProvider(this.serverConfig);
        this.clientProvider = this.createAxisProvider(this.clientConfig);
        this.axisServer = new AxisServer((EngineConfiguration)this.serverProvider);
        WSDDProvider.registerProvider((QName)QNAME_MULERPC_PROVIDER, (WSDDProvider)new WSDDJavaMuleProvider(this));
        try {
            this.registerTransportTypes();
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(new Message(122, (Object)e.getMessage()), (Throwable)e, (Object)this);
        }
    }

    protected void registerTransportTypes() throws ClassNotFoundException {
        Iterator iterator = this.getAxisTransportProtocols().keySet().iterator();
        while (iterator.hasNext()) {
            String protocol = (String)iterator.next();
            Object temp = this.getAxisTransportProtocols().get(protocol);
            Class clazz = null;
            clazz = temp instanceof String ? ClassHelper.loadClass((String)temp.toString(), ((Object)((Object)this)).getClass()) : (Class)temp;
            Call.setTransportForProtocol((String)protocol, (Class)clazz);
        }
    }

    protected SimpleProvider createAxisProvider(String config) throws InitialisationException {
        InputStream is = null;
        File f = new File(config);
        if (f.exists()) {
            try {
                is = new FileInputStream(f);
            }
            catch (FileNotFoundException e) {}
        } else {
            is = ClassHelper.getResourceAsStream((String)config, ((Object)((Object)this)).getClass());
        }
        FileProvider fileProvider = new FileProvider(config);
        if (is == null) {
            throw new InitialisationException(new Message(58, (Object)("Axis Configuration: " + config)), (Object)this);
        }
        fileProvider.setInputStream(is);
        return new MuleConfigProvider((EngineConfiguration)fileProvider);
    }

    public String getProtocol() {
        return "axis";
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return component.getDescriptor().getName();
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (endpoint instanceof ImmutableMuleEndpoint && !((ImmutableMuleEndpoint)endpoint).isSynchronousExplicitlySet() && !endpoint.isSynchronous()) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"overriding endpoint synchronicity and setting it to true. Web service requests are executed in a single thread");
            }
            endpoint.setSynchronous(true);
        }
        return super.createReceiver(component, endpoint);
    }

    protected void unregisterReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        block6: {
            String endpointKey = this.getCounterEndpointKey(receiver.getEndpointURI());
            Map endpointCounters = (Map)this.axisDescriptor.getProperties().get(ENDPOINT_COUNTERS_PROPERTY);
            if (endpointCounters == null) {
                this.logger.error((Object)"There are no endpoints registered on the Axis service descriptor");
                return;
            }
            Integer count = (Integer)endpointCounters.get(endpointKey);
            if (count == null) {
                this.logger.error((Object)("There are no services registered on: " + endpointKey));
                return;
            }
            if (count > 1) {
                this.logger.warn((Object)("There are '" + count + "' services registered on endpoint: " + endpointKey + ". Not unregistering the endpoint at this time"));
                count = new Integer(count - 1);
                endpointCounters.put(endpointKey, count);
                return;
            }
            endpointCounters.remove(endpointKey);
            Iterator iterator = this.axisDescriptor.getInboundRouter().getEndpoints().iterator();
            if (!iterator.hasNext()) break block6;
            UMOEndpoint umoEndpoint = (UMOEndpoint)iterator.next();
            if (endpointKey.startsWith(umoEndpoint.getEndpointURI().getAddress())) {
                this.logger.info((Object)("Unregistering Axis endpoint: " + endpointKey + " for service: " + receiver.getComponent().getDescriptor().getName()));
            }
            try {
                umoEndpoint.getConnector().unregisterListener(receiver.getComponent(), receiver.getEndpoint());
            }
            catch (Exception e) {
                this.logger.error((Object)("Failed to unregistering Axis endpoint: " + endpointKey + " for service: " + receiver.getComponent().getDescriptor().getName() + ". Error is: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    protected void registerReceiverWithMuleService(UMOMessageReceiver receiver, UMOEndpointURI ep) throws UMOException {
        Integer count;
        HashMap<String, Integer> endpointCounters;
        if (this.axisDescriptor == null) {
            this.axisDescriptor = (MuleDescriptor)MuleManager.getInstance().getModel().getDescriptor(AXIS_SERVICE_COMPONENT_NAME);
            if (this.axisDescriptor == null) {
                this.axisDescriptor = new MuleDescriptor(AXIS_SERVICE_COMPONENT_NAME);
                this.axisDescriptor.setImplementation((Object)(class$org$mule$providers$soap$axis$AxisServiceComponent == null ? (class$org$mule$providers$soap$axis$AxisServiceComponent = AxisConnector.class$("org.mule.providers.soap.axis.AxisServiceComponent")) : class$org$mule$providers$soap$axis$AxisServiceComponent).getName());
            } else {
                MuleManager.getInstance().getModel().unregisterComponent((UMODescriptor)this.axisDescriptor);
            }
            if (this.axisDescriptor.getProperties().get("axisServer") == null) {
                this.axisDescriptor.getProperties().put("axisServer", this.axisServer);
            }
            this.axisDescriptor.setContainerManaged(false);
        }
        String serviceName = receiver.getComponent().getDescriptor().getName();
        String endpoint = receiver.getEndpointURI().getAddress() + "/" + serviceName;
        String scheme = ep.getScheme().toLowerCase();
        boolean sync = receiver.getEndpoint().isSynchronous();
        if (scheme.equals("http") || scheme.equals("tcp")) {
            sync = true;
        }
        if ((endpointCounters = (HashMap<String, Integer>)this.axisDescriptor.getProperties().get(ENDPOINT_COUNTERS_PROPERTY)) == null) {
            endpointCounters = new HashMap<String, Integer>();
        }
        if ((count = (Integer)endpointCounters.get(endpoint)) == null) {
            count = new Integer(0);
        }
        if (count == 0) {
            MuleEndpoint serviceEndpoint = new MuleEndpoint(endpoint, true);
            serviceEndpoint.setSynchronous(sync);
            serviceEndpoint.setName(ep.getScheme() + ":" + serviceName);
            serviceEndpoint.setFilter(receiver.getEndpoint().getFilter());
            this.axisDescriptor.getInboundRouter().addEndpoint((UMOEndpoint)serviceEndpoint);
        }
        count = new Integer(count + 1);
        endpointCounters.put(endpoint, count);
        this.axisDescriptor.getProperties().put(ENDPOINT_COUNTERS_PROPERTY, endpointCounters);
    }

    private String getCounterEndpointKey(UMOEndpointURI endpointURI) {
        StringBuffer endpointKey = new StringBuffer();
        endpointKey.append(endpointURI.getScheme());
        endpointKey.append("://");
        endpointKey.append(endpointURI.getHost());
        if (endpointURI.getPort() > -1) {
            endpointKey.append(":");
            endpointKey.append(endpointURI.getPort());
        }
        return endpointKey.toString();
    }

    protected void doStart() throws UMOException {
        this.axisServer.start();
    }

    protected void doStop() throws UMOException {
        this.axisServer.stop();
    }

    public String getServerConfig() {
        return this.serverConfig;
    }

    public void setServerConfig(String serverConfig) {
        this.serverConfig = serverConfig;
    }

    public List getBeanTypes() {
        return this.beanTypes;
    }

    public void setBeanTypes(List beanTypes) {
        this.beanTypes = beanTypes;
    }

    public void onEvent(UMOServerEvent event) {
        if (event.getAction() == 206 && !MuleManager.getInstance().getModel().isComponentRegistered(AXIS_SERVICE_COMPONENT_NAME)) {
            try {
                MuleManager.getInstance().getModel().registerComponent((UMODescriptor)this.axisDescriptor);
                Iterator iterator = this.servletServices.iterator();
                while (iterator.hasNext()) {
                    SOAPService service = (SOAPService)iterator.next();
                    ServletConnector servletConnector = (ServletConnector)ConnectorFactory.getConnectorByProtocol((String)"servlet");
                    String url = servletConnector.getServletUrl();
                    if (url != null) {
                        service.getServiceDescription().setEndpointURL(url + "/" + service.getName());
                        continue;
                    }
                    this.logger.error((Object)("The servletUrl property on the ServletConntector has not been set this means that wsdl generation for service '" + service.getName() + "' may be incorrect"));
                }
                this.servletServices.clear();
                this.servletServices = null;
            }
            catch (UMOException e) {
                this.handleException((Exception)((Object)e));
            }
        }
    }

    public String getClientConfig() {
        return this.clientConfig;
    }

    public void setClientConfig(String clientConfig) {
        this.clientConfig = clientConfig;
    }

    public AxisServer getAxisServer() {
        return this.axisServer;
    }

    public void setAxisServer(AxisServer axisServer) {
        this.axisServer = axisServer;
    }

    public SimpleProvider getServerProvider() {
        return this.serverProvider;
    }

    public void setServerProvider(SimpleProvider serverProvider) {
        this.serverProvider = serverProvider;
    }

    public SimpleProvider getClientProvider() {
        return this.clientProvider;
    }

    public void setClientProvider(SimpleProvider clientProvider) {
        this.clientProvider = clientProvider;
    }

    public Map getAxisTransportProtocols() {
        return this.axisTransportProtocols;
    }

    public void setAxisTransportProtocols(Map axisTransportProtocols) {
        this.axisTransportProtocols.putAll(axisTransportProtocols);
    }

    void addServletService(SOAPService service) {
        this.servletServices.add(service);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

