/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.Iterator;
import javax.activation.DataHandler;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.MessageContext;
import org.apache.axis.attachments.AttachmentPart;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.providers.soap.axis.MuleSoapHeaders;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.MessagingException;
import org.mule.umo.transformer.UMOTransformer;

public class AxisMessageAdapter
extends AbstractMessageAdapter {
    private Object payload;
    private SOAPMessage message;
    private UMOTransformer trans;

    public AxisMessageAdapter(Object message) throws MessagingException {
        block9: {
            this.trans = new SerializableToByteArray();
            this.payload = message;
            try {
                MessageContext ctx = MessageContext.getCurrentContext();
                if (ctx == null) break block9;
                MuleSoapHeaders header = new MuleSoapHeaders(ctx.getMessage().getSOAPPart().getEnvelope().getHeader());
                if (header.getReplyTo() != null && !"".equals(header.getReplyTo())) {
                    this.setReplyTo(header.getReplyTo());
                }
                if (header.getCorrelationGroup() != null && !"".equals(header.getCorrelationGroup()) && !"-1".equals(header.getCorrelationGroup())) {
                    this.setCorrelationGroupSize(Integer.parseInt(header.getCorrelationGroup()));
                }
                if (header.getCorrelationSequence() != null && !"".equals(header.getCorrelationSequence()) && !"-1".equals(header.getCorrelationSequence())) {
                    this.setCorrelationSequence(Integer.parseInt(header.getCorrelationSequence()));
                }
                if (header.getCorrelationId() != null && !"".equals(header.getCorrelationId())) {
                    this.setCorrelationId(header.getCorrelationId());
                }
                this.message = ctx.getMessage();
                int x = 1;
                try {
                    Iterator i = this.message.getAttachments();
                    while (i.hasNext()) {
                        this.addAttachment(String.valueOf(x), ((AttachmentPart)i.next()).getActivationDataHandler());
                        ++x;
                    }
                }
                catch (Exception e) {
                    this.logger.fatal((Object)"Failed to read attachments", (Throwable)e);
                }
            }
            catch (SOAPException e) {
                throw new MessagingException(new Message("soap", 5), message, (Throwable)e);
            }
        }
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.getPayloadAsBytes());
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return (byte[])this.trans.transform(this.payload);
    }

    public Object getPayload() {
        return this.payload;
    }

    public SOAPMessage getSoapMessage() {
        return this.message;
    }

    public void addAttachment(String name, DataHandler dataHandler) throws Exception {
        this.message.addAttachmentPart((javax.xml.soap.AttachmentPart)new AttachmentPart(dataHandler));
        super.addAttachment(name, dataHandler);
    }

    public void removeAttachment(String name) throws Exception {
        if (!"all".equalsIgnoreCase(name)) {
            throw new SOAPException(new Message("soap", 6).toString());
        }
        this.message.removeAllAttachments();
        this.attachments.clear();
    }
}

