/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import javax.xml.namespace.QName;
import org.apache.axis.AxisEngine;
import org.apache.axis.AxisProperties;
import org.apache.axis.EngineConfiguration;
import org.apache.axis.Handler;
import org.apache.axis.MessageContext;
import org.apache.axis.SimpleChain;
import org.apache.axis.SimpleTargetedChain;
import org.apache.axis.client.AxisClient;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.configuration.SimpleProvider;
import org.apache.axis.constants.Style;
import org.apache.axis.constants.Use;
import org.apache.axis.message.SOAPEnvelope;
import org.apache.axis.wsdl.gen.Parser;
import org.apache.axis.wsdl.symbolTable.SymTabEntry;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.NullPayload;
import org.mule.providers.soap.NamedParameter;
import org.mule.providers.soap.SoapMethod;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.extensions.MuleSoapHeadersHandler;
import org.mule.providers.soap.axis.extensions.UniversalSender;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.transformer.TransformerException;
import org.mule.util.BeanUtils;

public class AxisMessageDispatcher
extends AbstractMessageDispatcher {
    private Map services = new HashMap();
    private Map callParameters;
    protected SimpleProvider clientConfig;
    static /* synthetic */ Class class$org$apache$axis$wsdl$symbolTable$ServiceEntry;

    public AxisMessageDispatcher(AxisConnector connector) throws UMOException {
        super((AbstractConnector)connector);
        this.createClientConfig();
    }

    public void doDispose() {
    }

    protected synchronized Service getService(UMOEvent event) throws Exception {
        String wsdlUrl = this.getWsdlUrl(event);
        Service service = (Service)this.services.get(wsdlUrl);
        if (service == null) {
            service = this.createService(event);
            this.services.put(wsdlUrl, service);
        }
        return service;
    }

    protected void createClientConfig() {
        this.clientConfig = new SimpleProvider();
        MuleSoapHeadersHandler muleHandler = new MuleSoapHeadersHandler();
        SimpleChain reqHandler = new SimpleChain();
        SimpleChain respHandler = new SimpleChain();
        reqHandler.addHandler((Handler)muleHandler);
        respHandler.addHandler((Handler)muleHandler);
        UniversalSender pivot = new UniversalSender();
        SimpleTargetedChain transport = new SimpleTargetedChain((Handler)reqHandler, (Handler)pivot, (Handler)respHandler);
        this.clientConfig.deployTransport("MuleTransport", (Handler)transport);
    }

    protected Service createService(UMOEvent event) throws Exception {
        String wsdlUrl = this.getWsdlUrl(event);
        if (wsdlUrl.length() > 0) {
            Parser parser = new Parser();
            parser.run(wsdlUrl);
            HashMap map = parser.getSymbolTable().getHashMap();
            ArrayList entries = new ArrayList();
            Iterator it = map.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                Vector v = (Vector)entry.getValue();
                Iterator it2 = v.iterator();
                while (it2.hasNext()) {
                    SymTabEntry e;
                    if (!(class$org$apache$axis$wsdl$symbolTable$ServiceEntry == null ? AxisMessageDispatcher.class$("org.apache.axis.wsdl.symbolTable.ServiceEntry") : class$org$apache$axis$wsdl$symbolTable$ServiceEntry).isInstance(e = (SymTabEntry)it2.next())) continue;
                    entries.add(entry.getKey());
                }
            }
            if (entries.size() != 1) {
                throw new Exception("Need one and only one service entry, found " + entries.size());
            }
            Service service = new Service(parser, (QName)entries.get(0));
            service.setEngineConfiguration((EngineConfiguration)this.clientConfig);
            service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)this.clientConfig));
            return service;
        }
        Service service = new Service();
        service.setEngineConfiguration((EngineConfiguration)this.clientConfig);
        service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)this.clientConfig));
        return service;
    }

    protected String getWsdlUrl(UMOEvent event) {
        Object wsdlUrlProp = event.getProperties().get("wsdlUrl");
        String wsdlUrl = "";
        if (wsdlUrlProp != null) {
            wsdlUrl = wsdlUrlProp.toString();
        }
        return wsdlUrl;
    }

    public void doDispatch(UMOEvent event) throws Exception {
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)"true");
        Call call = this.getCall(event);
        Object[] args = this.getArgs(event);
        call.setProperty("axis.one.way", (Object)Boolean.TRUE);
        call.setProperty("MULE_EVENT", (Object)event);
        call.invoke(args);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        AxisProperties.setProperty((String)"axis.doAutoTypes", (String)"true");
        Call call = this.getCall(event);
        Object[] args = this.getArgs(event);
        Object result = call.invoke(args);
        if (result == null) {
            return null;
        }
        MuleMessage resultMessage = new MuleMessage(result, event.getProperties());
        this.setMessageContextProperties((UMOMessage)resultMessage, call.getMessageContext());
        return resultMessage;
    }

    private Call getCall(UMOEvent event) throws Exception {
        String methodNamespace;
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        String method = (String)endpointUri.getParams().remove("method");
        if (method == null && (method = (String)event.getEndpoint().getProperties().get("method")) == null) {
            throw new DispatchException(new Message("soap", 4), event.getMessage(), event.getEndpoint());
        }
        Call call = (Call)this.getService(event).createCall();
        String style = (String)event.getProperties().get("style");
        String use = (String)event.getProperties().get("use");
        if (style != null) {
            Style s = Style.getStyle((String)style);
            if (s == null) {
                throw new IllegalArgumentException(new Message(154, (Object)("style=" + style)).toString());
            }
            call.setOperationStyle(s);
        }
        if (use != null) {
            Use u = Use.getUse((String)use);
            if (u == null) {
                throw new IllegalArgumentException(new Message(154, (Object)("use=" + use)).toString());
            }
            call.setOperationUse(u);
        }
        BeanUtils.populateWithoutFail((Object)call, (Map)event.getEndpoint().getProperties(), (boolean)false);
        call.setTargetEndpointAddress(endpointUri.toString());
        String soapAction = (String)event.getProperty("soapAction");
        if (soapAction != null) {
            soapAction = this.parseSoapAction(soapAction, method, event);
            call.setSOAPActionURI(soapAction);
            call.setUseSOAPAction(Boolean.TRUE.booleanValue());
        }
        if ((methodNamespace = (String)event.getProperty("methodNamespace")) != null) {
            call.setOperationName(new QName(methodNamespace, method));
        } else {
            call.setOperationName(new QName(method));
        }
        call.setProperty("MULE_EVENT", (Object)event);
        int timeout = event.getIntProperty("MULE_EVENT_TIMEOUT", -1);
        if (timeout >= 0) {
            call.setTimeout(new Integer(timeout));
        }
        if (endpointUri.getUserInfo() != null) {
            call.setUsername(endpointUri.getUsername());
            call.setPassword(endpointUri.getPassword());
        }
        this.setCallParams(call, event, call.getOperationName());
        return call;
    }

    private Object[] getArgs(UMOEvent event) throws TransformerException {
        Object payload = event.getTransformedMessage();
        Object[] args = payload instanceof Object[] ? (Object[])payload : new Object[]{payload};
        return args;
    }

    private void setMessageContextProperties(UMOMessage message, MessageContext ctx) {
        Object temp = ctx.getProperty("MULE_CORRELATION_ID");
        if (temp != null && !"".equals(temp.toString())) {
            message.setCorrelationId(temp.toString());
        }
        if ((temp = ctx.getProperty("MULE_CORRELATION_GROUP_SIZE")) != null && !"".equals(temp.toString())) {
            message.setCorrelationGroupSize(Integer.parseInt(temp.toString()));
        }
        if ((temp = ctx.getProperty("MULE_CORRELATION_SEQUENCE")) != null && !"".equals(temp.toString())) {
            message.setCorrelationSequence(Integer.parseInt(temp.toString()));
        }
        if ((temp = ctx.getProperty("MULE_REPLYTO")) != null && !"".equals(temp.toString())) {
            message.setReplyTo((Object)temp.toString());
        }
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        Service service = new Service();
        service.setEngineConfiguration((EngineConfiguration)this.clientConfig);
        service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)this.clientConfig));
        Call call = new Call(service);
        call.setSOAPActionURI(endpointUri.toString());
        call.setTargetEndpointAddress(endpointUri.toString());
        String method = (String)endpointUri.getParams().remove("method");
        call.setOperationName(method);
        Properties params = endpointUri.getUserParams();
        Object[] args = new Object[params.size()];
        int i = 0;
        Iterator<Object> iterator = params.values().iterator();
        while (iterator.hasNext()) {
            args[i] = iterator.next();
            ++i;
        }
        call.setOperationName(method);
        Object result = call.invoke(method, args);
        return this.createMessage(result, call);
    }

    public UMOMessage receive(String endpoint, Object[] args) throws Exception {
        Service service = new Service();
        service.setEngineConfiguration((EngineConfiguration)this.clientConfig);
        service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)this.clientConfig));
        Call call = new Call(service);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        if (!endpoint.startsWith("axis:")) {
            endpoint = "axis:" + endpoint;
        }
        MuleEndpointURI ep = new MuleEndpointURI(endpoint);
        String method = (String)ep.getParams().remove("method");
        call.setOperationName(method);
        call.setOperationName(method);
        Object result = call.invoke(method, args);
        return this.createMessage(result, call);
    }

    public UMOMessage receive(String endpoint, javax.xml.soap.SOAPEnvelope envelope) throws Exception {
        Service service = new Service();
        service.setEngineConfiguration((EngineConfiguration)this.clientConfig);
        service.setEngine((AxisEngine)new AxisClient((EngineConfiguration)this.clientConfig));
        Call call = new Call(service);
        call.setSOAPActionURI(endpoint);
        call.setTargetEndpointAddress(endpoint);
        SOAPEnvelope result = call.invoke(new org.apache.axis.Message((Object)envelope));
        return this.createMessage(result, call);
    }

    protected UMOMessage createMessage(Object result, Call call) {
        if (result == null) {
            result = new NullPayload();
        }
        HashMap<Object, Object> props = new HashMap<Object, Object>();
        Iterator iter = call.getMessageContext().getPropertyNames();
        while (iter.hasNext()) {
            Object key = iter.next();
            props.put(key, call.getMessageContext().getProperty(key.toString()));
        }
        props.put("soap.message", call.getMessageContext().getMessage());
        return new MuleMessage(result, props);
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public String parseSoapAction(String soapAction, String method, UMOEvent event) {
        if (soapAction.indexOf("${") > -1) {
            UMOEndpointURI endpointURI = event.getEndpoint().getEndpointURI();
            soapAction = soapAction.replaceFirst("\\$\\{method\\}", method);
            soapAction = soapAction.replaceFirst("\\$\\{address\\}", endpointURI.getAddress());
            soapAction = soapAction.replaceFirst("\\$\\{scheme\\}", endpointURI.getScheme());
            soapAction = soapAction.replaceFirst("\\$\\{host\\}", endpointURI.getHost());
            soapAction = soapAction.replaceFirst("\\$\\{port\\}", String.valueOf(endpointURI.getPort()));
            soapAction = soapAction.replaceFirst("\\$\\{path\\}", endpointURI.getPath());
            soapAction = soapAction.replaceFirst("\\$\\{hostInfo\\}", endpointURI.getScheme() + "://" + endpointURI.getHost() + (endpointURI.getPort() > -1 ? ":" + String.valueOf(endpointURI.getPort()) : ""));
            soapAction = soapAction.replaceFirst("\\$\\{serviceName\\}", event.getComponent().getDescriptor().getName());
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("SoapAction for this call is: " + soapAction));
        }
        return soapAction;
    }

    private void setCallParams(Call call, UMOEvent event, QName method) throws ClassNotFoundException {
        SoapMethod soapMethod;
        if (this.callParameters == null) {
            this.loadCallParams(event, method.getNamespaceURI());
        }
        if ((soapMethod = (SoapMethod)event.removeProperty((Object)"MULE_SOAP_METHOD")) == null) {
            soapMethod = (SoapMethod)this.callParameters.get(method);
        }
        if (soapMethod != null) {
            Iterator iterator = soapMethod.getNamedParameters().iterator();
            while (iterator.hasNext()) {
                NamedParameter parameter = (NamedParameter)iterator.next();
                call.addParameter(parameter.getName(), parameter.getType(), parameter.getMode());
            }
            if (soapMethod.getReturnType() != null) {
                call.setReturnType(soapMethod.getReturnType());
            }
            if (soapMethod.getReturnClass() != null) {
                call.setReturnClass(soapMethod.getReturnClass());
            }
        }
    }

    private void loadCallParams(UMOEvent event, String namespace) throws ClassNotFoundException {
        this.callParameters = new HashMap();
        Map methodCalls = (Map)event.getProperty("soapMethods");
        if (methodCalls == null) {
            return;
        }
        Iterator iterator = methodCalls.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            SoapMethod soapMethod = "".equals(namespace) || namespace == null ? (entry.getValue() instanceof List ? new SoapMethod(entry.getKey().toString(), (List)entry.getValue()) : new SoapMethod(entry.getKey().toString(), entry.getValue().toString())) : (entry.getValue() instanceof List ? new SoapMethod(new QName(namespace, entry.getKey().toString()), (List)entry.getValue()) : new SoapMethod(new QName(namespace, entry.getKey().toString()), entry.getValue().toString()));
            this.callParameters.put(soapMethod.getName(), soapMethod);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

