/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import java.lang.reflect.Proxy;
import org.apache.axis.AxisFault;
import org.apache.axis.Constants;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.soap.SOAPService;
import org.apache.axis.providers.java.RPCProvider;
import org.mule.MuleManager;
import org.mule.impl.RequestContext;
import org.mule.providers.soap.ServiceProxy;
import org.mule.providers.soap.axis.AxisConnector;
import org.mule.providers.soap.axis.AxisMessageReceiver;
import org.mule.umo.UMOSession;

public class MuleProvider
extends RPCProvider {
    private AxisConnector connector;

    public MuleProvider(AxisConnector connector) {
        this.connector = connector;
    }

    protected Object makeNewServiceObject(MessageContext messageContext, String s) throws Exception {
        AxisMessageReceiver receiver = (AxisMessageReceiver)this.connector.getReceiver(messageContext.getTargetService());
        if (receiver == null) {
            throw new AxisFault("Could not find Mule registered service: " + s);
        }
        Class[] classes = ServiceProxy.getInterfacesForComponent(receiver.getComponent());
        return ServiceProxy.createAxisProxy(receiver, true, classes);
    }

    protected Class getServiceClass(String s, SOAPService soapService, MessageContext messageContext) throws AxisFault {
        UMOSession session = MuleManager.getInstance().getModel().getComponentSession(soapService.getName());
        try {
            Class[] classes = ServiceProxy.getInterfacesForComponent(session.getComponent());
            return Proxy.getProxyClass(Thread.currentThread().getContextClassLoader(), classes);
        }
        catch (Exception e) {
            throw new AxisFault("Failed to implementation class for component: " + e.getMessage(), (Throwable)e);
        }
    }

    public void invoke(MessageContext msgContext) throws AxisFault {
        super.invoke(msgContext);
        if (RequestContext.getExceptionPayload() != null) {
            Throwable t = RequestContext.getExceptionPayload().getException();
            if (t instanceof Exception) {
                AxisFault fault = AxisFault.makeFault((Exception)((Exception)t));
                if (t instanceof RuntimeException) {
                    fault.addFaultDetail(Constants.QNAME_FAULTDETAIL_RUNTIMEEXCEPTION, "true");
                }
                throw fault;
            }
            throw (Error)t;
        }
    }
}

