/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.axis.extensions;

import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import org.apache.axis.AxisFault;
import org.apache.axis.MessageContext;
import org.apache.axis.handlers.BasicHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.providers.soap.axis.MuleSoapHeaders;
import org.mule.umo.UMOEvent;

public class MuleSoapHeadersHandler
extends BasicHandler {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$soap$axis$extensions$MuleSoapHeadersHandler == null ? (class$org$mule$providers$soap$axis$extensions$MuleSoapHeadersHandler = MuleSoapHeadersHandler.class$("org.mule.providers.soap.axis.extensions.MuleSoapHeadersHandler")) : class$org$mule$providers$soap$axis$extensions$MuleSoapHeadersHandler));
    static /* synthetic */ Class class$org$mule$providers$soap$axis$extensions$MuleSoapHeadersHandler;

    public void invoke(MessageContext msgContext) throws AxisFault {
        boolean setMustUnderstand = msgContext.isPropertyTrue("MULE_HEADER_MUST_UNDERSTAND");
        try {
            if (msgContext.isClient()) {
                if (!msgContext.getPastPivot()) {
                    this.processClientRequest(msgContext, setMustUnderstand);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("After Client Request, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                    }
                } else {
                    this.processClientResponse(msgContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("After Client Response, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                    }
                }
            } else if (!msgContext.getPastPivot()) {
                this.processServerRequest(msgContext);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("After Server Request, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                }
            } else {
                this.processServerResponse(msgContext, setMustUnderstand);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("After Server Response, Message is:\n" + msgContext.getRequestMessage().getSOAPPartAsString()));
                }
            }
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Exception)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void processClientRequest(MessageContext msgContext, boolean setMustUnderstand) throws Exception {
        MessageContext soapMsgContext = msgContext;
        SOAPMessage msg = soapMsgContext.getMessage();
        if (msg == null) {
            return;
        }
        UMOEvent event = (UMOEvent)msgContext.getProperty("MULE_EVENT");
        if (event == null) {
            return;
        }
        MessageContext messageContext = msgContext;
        synchronized (messageContext) {
            MuleSoapHeaders headers = new MuleSoapHeaders(event);
            headers.addHeaders(msgContext.getMessage().getSOAPPart().getEnvelope());
        }
    }

    protected void processClientResponse(MessageContext msgContext) throws Exception {
        MessageContext soapMsgContext = msgContext;
        SOAPMessage msg = soapMsgContext.getMessage();
        if (msg == null) {
            return;
        }
        SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
        MuleSoapHeaders headers = new MuleSoapHeaders(env.getHeader());
        headers.setAsClientProperties(msgContext);
    }

    protected void processServerRequest(MessageContext msgContext) throws Exception {
        MessageContext soapMsgContext = msgContext;
        SOAPMessage msg = soapMsgContext.getMessage();
        if (msg == null) {
            return;
        }
        MuleSoapHeaders headers = new MuleSoapHeaders(msg.getSOAPPart().getEnvelope().getHeader());
        msgContext.setProperty("MULE_REQUEST_HEADERS", (Object)headers);
    }

    protected void processServerResponse(MessageContext msgContext, boolean setMustUnderstand) throws Exception {
        MessageContext soapMsgContext = msgContext;
        SOAPMessage msg = soapMsgContext.getMessage();
        if (msg == null) {
            return;
        }
        MuleSoapHeaders headers = (MuleSoapHeaders)msgContext.getProperty("MULE_REQUEST_HEADERS");
        if (headers == null) {
            return;
        }
        headers.addHeaders(msgContext.getMessage().getSOAPPart().getEnvelope());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

