/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.glue;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageReceiver;

public class GlueConnector
extends AbstractServiceEnabledConnector {
    private List serverEndpoints = new ArrayList();
    private Map context;

    public String getProtocol() {
        return "glue";
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        boolean createServer = this.shouldCreateServer(endpoint.getEndpointURI().getAddress());
        UMOMessageReceiver receiver = this.serviceDescriptor.createMessageReceiver((UMOConnector)this, component, endpoint, new Object[]{new Boolean(createServer)});
        if (createServer) {
            this.serverEndpoints.add(endpoint.getEndpointURI().getAddress());
        }
        return receiver;
    }

    protected Object getReceiverKey(UMOComponent component, UMOEndpoint endpoint) {
        return endpoint.getEndpointURI().getAddress() + "/" + component.getDescriptor().getName();
    }

    private boolean shouldCreateServer(String endpoint) throws URISyntaxException {
        URI uri = new URI(endpoint);
        String ep = uri.getScheme() + "://" + uri.getHost();
        if (uri.getPort() != -1) {
            ep = ep + ":" + uri.getPort();
        }
        Iterator iterator = this.serverEndpoints.iterator();
        while (iterator.hasNext()) {
            String s = (String)iterator.next();
            if (!s.startsWith(ep)) continue;
            return false;
        }
        return true;
    }

    public Map getContext() {
        return this.context;
    }

    public void setContext(Map context) {
        this.context = context;
    }
}

