/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.soap.glue;

import electric.glue.context.ThreadContext;
import electric.service.IService;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.transformer.UMOTransformer;
import org.mule.util.IteratorAdapter;

public class GlueMessageAdapter
extends AbstractMessageAdapter {
    private Object message;
    private UMOTransformer trans = new SerializableToByteArray();

    public GlueMessageAdapter(Object message) {
        String value;
        if (message instanceof GlueMessageHolder) {
            GlueMessageHolder holder = (GlueMessageHolder)message;
            this.message = holder.getMessage();
            IteratorAdapter iter = new IteratorAdapter(holder.getService().getContext().getPropertyNames());
            while (iter.hasNext()) {
                String key = iter.next().toString();
                this.setProperty(key, holder.getService().getContext().getProperty(key));
            }
        } else {
            this.message = message;
        }
        if ((value = (String)ThreadContext.removeProperty((String)"MULE_REPLYTO")) != null) {
            this.setReplyTo(value);
        }
        if ((value = (String)ThreadContext.removeProperty((String)"MULE_CORRELATION_ID")) != null) {
            this.setCorrelationId(value);
        }
        if ((value = (String)ThreadContext.removeProperty((String)"MULE_CORRELATION_SEQUENCE")) != null && !"-1".equals(value)) {
            this.setCorrelationSequence(Integer.parseInt(value));
        }
        if ((value = (String)ThreadContext.removeProperty((String)"MULE_CORRELATION_GROUP_SIZE")) != null && !"-1".equals(value)) {
            this.setCorrelationGroupSize(Integer.parseInt(value));
        }
    }

    public String getPayloadAsString() throws Exception {
        return new String(this.getPayloadAsBytes());
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return (byte[])this.trans.transform(this.message);
    }

    public Object getPayload() {
        return this.message;
    }

    public static class GlueMessageHolder {
        private Object message;
        private IService service;

        public GlueMessageHolder(Object message, IService service) {
            this.message = message;
            this.service = service;
        }

        public Object getMessage() {
            return this.message;
        }

        public IService getService() {
            return this.service;
        }
    }
}

