/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.stream;

import java.io.InputStream;
import org.mule.impl.MuleMessage;
import org.mule.providers.PollingMessageReceiver;
import org.mule.providers.stream.StreamConnector;
import org.mule.providers.stream.SystemStreamConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.Utility;

public class StreamMessageReceiver
extends PollingMessageReceiver {
    public static final int DEFAULT_BUFFER_SIZE = 8192;
    private int bufferSize = 8192;
    private InputStream inputStream;
    private StreamConnector connector;

    public StreamMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, InputStream stream, Long checkFrequency) throws InitialisationException {
        super(connector, component, endpoint, checkFrequency);
        this.connector = (StreamConnector)connector;
        this.inputStream = stream;
        if (connector instanceof SystemStreamConnector) {
            String promptMessage = (String)endpoint.getProperties().get("promptMessage");
            String messageDelayTime = (String)endpoint.getProperties().get("messageDelayTime");
            if (promptMessage != null) {
                ((SystemStreamConnector)connector).setPromptMessage(promptMessage);
            }
            if (messageDelayTime != null) {
                ((SystemStreamConnector)connector).setMessageDelayTime(new Long(messageDelayTime));
            }
        }
    }

    public void doConnect() throws Exception {
    }

    public void doDisconnect() throws Exception {
    }

    public void poll() {
        try {
            if (this.inputStream.available() == 0) {
                return;
            }
            byte[] buf = new byte[this.getBufferSize()];
            int len = this.inputStream.read(buf);
            if (len == -1) {
                return;
            }
            String message = new String(buf, 0, len);
            if (message.endsWith(Utility.CRLF)) {
                message = message.substring(0, message.length() - Utility.CRLF.length());
            }
            MuleMessage umoMessage = new MuleMessage((Object)this.connector.getMessageAdapter(message));
            this.routeMessage((UMOMessage)umoMessage, this.endpoint.isSynchronous());
            ((StreamConnector)this.endpoint.getConnector()).reinitialise();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }
}

