/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.Utility;

public class TcpMessageDispatcher
extends AbstractMessageDispatcher {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$tcp$TcpMessageDispatcher == null ? (class$org$mule$providers$tcp$TcpMessageDispatcher = TcpMessageDispatcher.class$("org.mule.providers.tcp.TcpMessageDispatcher")) : class$org$mule$providers$tcp$TcpMessageDispatcher));
    private TcpConnector connector;
    private Socket socket;
    private InetAddress inetAddress;
    private int port;
    private PrintWriter printWriter;
    private DataOutputStream dataOut;
    private SynchronizedBoolean initialised = new SynchronizedBoolean(false);
    static /* synthetic */ Class class$org$mule$providers$tcp$TcpMessageDispatcher;

    public TcpMessageDispatcher(TcpConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
        this.disposeOnCompletion = true;
    }

    protected void initialise(String endpoint) throws IOException, URISyntaxException {
        if (!this.initialised.get() || this.socket.isClosed()) {
            URI uri = new URI(endpoint);
            this.port = uri.getPort();
            this.inetAddress = InetAddress.getByName(uri.getHost());
            this.socket = this.createSocket(this.port, this.inetAddress);
            this.socket.setReuseAddress(true);
            this.socket.setReceiveBufferSize(this.connector.getBufferSize());
            this.socket.setSendBufferSize(this.connector.getBufferSize());
            this.socket.setSoTimeout(this.connector.getTimeout());
            this.printWriter = new PrintWriter(new BufferedWriter(new OutputStreamWriter(this.socket.getOutputStream())));
            this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
            this.initialised.set(true);
        }
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.initialise(event.getEndpoint().getEndpointURI().getAddress());
        Object payload = event.getTransformedMessage();
        this.write(this.socket, payload);
    }

    protected Socket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new Socket(inetAddress, port);
    }

    protected void write(Socket socket, Object data) throws IOException {
        if (data instanceof String) {
            this.printWriter.write(data.toString());
            this.printWriter.flush();
        } else if (data instanceof byte[]) {
            BufferedOutputStream bos = new BufferedOutputStream(this.dataOut);
            bos.write((byte[])data);
            bos.flush();
        } else {
            this.dataOut.write(Utility.objectToByteArray((Object)data));
            this.dataOut.flush();
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.initialise(event.getEndpoint().getEndpointURI().getAddress());
        Object payload = event.getTransformedMessage();
        boolean syncReceive = event.getBooleanProperty("MULE_SYNC_RECEIVE", MuleManager.getConfiguration().isSynchronousReceive());
        this.write(this.socket, payload);
        if (syncReceive) {
            try {
                byte[] result = this.receive(this.socket, event.getTimeout());
                this.dataOut.close();
                if (result == null) {
                    return null;
                }
                MuleMessage message = new MuleMessage(this.connector.getMessageAdapter(result));
                return message;
            }
            catch (SocketTimeoutException e) {
                logger.info((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + event.getEndpoint().getEndpointURI()));
                return null;
            }
        }
        this.dataOut.close();
        return event.getMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] receive(Socket socket, int timeout) throws IOException {
        block10: {
            block9: {
                dis = new DataInputStream(socket.getInputStream());
                if (timeout >= 0) {
                    socket.setSoTimeout(timeout);
                }
                baos = new ByteArrayOutputStream(this.connector.getBufferSize());
                buffer = new byte[this.connector.getBufferSize()];
                len = 0;
                try {
                    while ((len = dis.read(buffer, len, buffer.length)) != 0) {
                        if (len == -1) {
                            TcpMessageDispatcher.logger.debug((Object)"The socket is closed");
                            var7_7 = null;
                            var9_9 = null;
                            break block9;
                        }
                        baos.write(buffer, 0, len);
                        if (len == buffer.length) continue;
                    }
                    baos.flush();
                    var7_8 = baos.toByteArray();
                    break block10;
                }
                catch (Throwable var8_15) {
                    var9_11 = null;
                    try {
                        if (baos == null) throw var8_15;
                        baos.close();
                        throw var8_15;
                    }
                    catch (IOException e) {
                        TcpMessageDispatcher.logger.error((Object)("failed to close tcp stream: " + e));
                        throw var8_15;
                    }
                }
            }
            ** try [egrp 1[TRYBLOCK] [3 : 142->155)] { 
lbl33:
            // 1 sources

            if (baos == null) return var7_7;
            baos.close();
            return var7_7;
lbl36:
            // 1 sources

            catch (IOException e) {
                TcpMessageDispatcher.logger.error((Object)("failed to close tcp stream: " + e));
            }
            return var7_7;
        }
        var9_10 = null;
        ** try [egrp 1[TRYBLOCK] [3 : 142->155)] { 
lbl42:
        // 1 sources

        if (baos == null) return var7_8;
        baos.close();
        return var7_8;
lbl45:
        // 1 sources

        catch (IOException e) {
            TcpMessageDispatcher.logger.error((Object)("failed to close tcp stream: " + e));
        }
        return var7_8;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        this.initialise(endpointUri.getAddress());
        int origTimeout = this.socket.getSoTimeout();
        int newTimeout = Integer.parseInt(String.valueOf(timeout));
        if (origTimeout != newTimeout) {
            this.socket.setSoTimeout(Integer.parseInt(String.valueOf(timeout)));
        }
        try {
            MuleMessage message;
            byte[] result = this.receive(this.socket, Integer.parseInt(String.valueOf(timeout)));
            if (result == null) {
                UMOMessage uMOMessage = null;
                return uMOMessage;
            }
            MuleMessage muleMessage = message = new MuleMessage(this.connector.getMessageAdapter(new ByteArrayInputStream(result)));
            return muleMessage;
        }
        finally {
            if (origTimeout != newTimeout) {
                this.socket.setSoTimeout(origTimeout);
            }
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() throws UMOException {
        this.initialised.set(false);
        try {
            if (this.dataOut != null) {
                this.dataOut.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("failed to dispose Tcp dispatcher: " + e.getMessage()));
        }
        if (this.printWriter != null) {
            this.printWriter.close();
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException e) {
            logger.error((Object)("failed to dispose Tcp dispatcher: " + e.getMessage()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

