/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import EDU.oswego.cs.dl.util.concurrent.ThreadFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import org.mule.DisposeException;
import org.mule.InitialisationException;
import org.mule.impl.MuleMessage;
import org.mule.impl.ResponseOutputStream;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.tcp.TcpConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class TcpMessageReceiver
extends AbstractMessageReceiver
implements Runnable {
    private ServerSocket serverSocket = null;
    private PooledExecutor threadPool;
    private Thread worker;

    public TcpMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this.create((UMOConnector)connector, component, endpoint);
        connector.getReceiverThreadingProfile().setThreadFactory(this.getThreadFactory());
        this.threadPool = connector.getReceiverThreadingProfile().createPool(connector.getName());
        URI uri = endpoint.getEndpointURI().getUri();
        this.connect(uri);
        this.worker = new Thread((Runnable)this, connector.getName() + ".receiver");
        this.worker.start();
    }

    protected ThreadFactory getThreadFactory() {
        return new ThreadFactory(){

            public Thread newThread(Runnable runnable) {
                Thread thread = new Thread(runnable, this.toString());
                if (TcpMessageReceiver.this.isServerSide()) {
                    thread.setDaemon(true);
                } else {
                    thread.setPriority(7);
                }
                return thread;
            }
        };
    }

    protected void connect(URI uri) throws InitialisationException {
        int count = ((TcpConnector)this.connector).getRetryCount();
        long freq = ((TcpConnector)this.connector).getRetryFrequency();
        ++count;
        for (int i = 0; i < count; ++i) {
            try {
                this.serverSocket = this.createSocket(uri);
                break;
            }
            catch (Exception e) {
                this.logger.debug((Object)("Failed to bind to uri: " + uri), (Throwable)e);
                if (i < count - 1) {
                    try {
                        Thread.sleep(freq);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                throw new InitialisationException("Unable to bind to uri: " + uri + ". Reason: " + e);
            }
        }
    }

    protected ServerSocket createSocket(URI uri) throws Exception {
        String host = uri.getHost();
        InetAddress inetAddress = null;
        int backlog = ((TcpConnector)this.connector).getBacklog();
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        if ((inetAddress = InetAddress.getByName(host)).equals(InetAddress.getLocalHost()) || inetAddress.isLoopbackAddress() || host.trim().equals("localhost")) {
            return new ServerSocket(uri.getPort(), backlog);
        }
        return new ServerSocket(uri.getPort(), backlog, inetAddress);
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void run() {
        while (!this.disposing.get()) {
            Socket socket;
            block6: {
                if (!this.connector.isStarted() || this.disposing.get()) continue;
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    this.logger.trace((Object)("Server socket Accepted on: " + this.serverSocket.getLocalPort()));
                }
                catch (InterruptedIOException iie) {
                    this.logger.debug((Object)("Interupted IO doing serverSocket.accept: " + iie.getMessage()));
                }
                catch (Exception e) {
                    if (this.connector.isDisposed() || this.disposing.get()) break block6;
                    this.logger.warn((Object)("Accept failed on socket: " + e), (Throwable)e);
                    this.handleException(null, e);
                }
            }
            if (socket == null) continue;
            Runnable worker = this.createWorker(socket);
            try {
                this.threadPool.execute(worker);
            }
            catch (InterruptedException e) {
                this.logger.error((Object)("Tcp Server receiver interrupted: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void doDispose() throws UMOException {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
        try {
            this.threadPool.shutdownNow();
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
        catch (Exception e) {
            throw new DisposeException("Failed to close http port: " + e.getMessage(), (Throwable)e);
        }
        this.logger.info((Object)"Closed Tcp port");
    }

    protected Runnable createWorker(Socket socket) {
        return new TcpWorker(socket);
    }

    protected class TcpWorker
    implements Runnable,
    Disposable {
        protected Socket socket = null;
        protected DataInputStream dataIn;
        protected DataOutputStream dataOut;
        protected SynchronizedBoolean closed = new SynchronizedBoolean(false);

        public TcpWorker(Socket socket) {
            this.socket = socket;
        }

        public void dispose() {
            this.closed.set(true);
            try {
                if (this.socket != null) {
                    TcpMessageReceiver.this.logger.debug((Object)("Closing listener: " + this.socket.getInetAddress()));
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TcpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                int counter = 0;
                while (!this.socket.isClosed() && !TcpMessageReceiver.this.disposing.get()) {
                    byte[] b;
                    if (TcpMessageReceiver.this.isServerSide() && ++counter > 500) {
                        counter = 0;
                        Thread.yield();
                    }
                    if ((b = this.readStream(this.dataIn)) == null) {
                        break;
                    }
                    byte[] result = this.processData(b);
                    if (result != null) {
                        this.dataOut.write(result);
                    }
                    this.dataOut.flush();
                }
            }
            catch (Exception e) {
                TcpMessageReceiver.this.handleException("Failed to process tcp Request on: " + (this.socket != null ? this.socket.getInetAddress().toString() : "null"), e);
            }
            finally {
                this.dispose();
            }
        }

        protected byte[] processData(byte[] data) throws Exception {
            UMOMessageAdapter adapter = TcpMessageReceiver.this.connector.getMessageAdapter((Object)data);
            ResponseOutputStream os = new ResponseOutputStream(this.socket.getOutputStream(), this.socket);
            UMOMessage returnMessage = TcpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), TcpMessageReceiver.this.endpoint.isSynchronous(), (OutputStream)os);
            if (returnMessage != null) {
                return returnMessage.getPayloadAsBytes();
            }
            return null;
        }

        private byte[] readStream(InputStream is) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[((TcpConnector)TcpMessageReceiver.this.connector).getBufferSize()];
            int len = 0;
            try {
                while ((len = is.read(buffer)) == 0) {
                }
            }
            catch (SocketException e) {
                TcpMessageReceiver.this.logger.warn((Object)e.getMessage());
                return null;
            }
            if (len == -1) {
                TcpMessageReceiver.this.logger.info((Object)"The socket peer closed");
                return null;
            }
            do {
                baos.write(buffer, 0, len);
            } while (len >= buffer.length && (len = is.read(buffer)) > 0);
            baos.flush();
            baos.close();
            return baos.toByteArray();
        }
    }
}

