/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.tcp.TcpConnector;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.Utility;

public class TcpMessageDispatcher
extends AbstractMessageDispatcher {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$tcp$TcpMessageDispatcher == null ? (class$org$mule$providers$tcp$TcpMessageDispatcher = TcpMessageDispatcher.class$("org.mule.providers.tcp.TcpMessageDispatcher")) : class$org$mule$providers$tcp$TcpMessageDispatcher));
    private TcpConnector connector;
    static /* synthetic */ Class class$org$mule$providers$tcp$TcpMessageDispatcher;

    public TcpMessageDispatcher(TcpConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    protected Socket initSocket(String endpoint) throws IOException, URISyntaxException {
        URI uri = new URI(endpoint);
        int port = uri.getPort();
        InetAddress inetAddress = InetAddress.getByName(uri.getHost());
        Socket socket = this.createSocket(port, inetAddress);
        socket.setReuseAddress(true);
        socket.setReceiveBufferSize(this.connector.getBufferSize());
        socket.setSendBufferSize(this.connector.getBufferSize());
        socket.setSoTimeout(this.connector.getTimeout());
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDispatch(UMOEvent event) throws Exception {
        Socket socket = null;
        try {
            Object payload = event.getTransformedMessage();
            socket = this.initSocket(event.getEndpoint().getEndpointURI().getAddress());
            this.write(socket, payload);
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
    }

    protected Socket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new Socket(inetAddress, port);
    }

    protected void write(Socket socket, Object data) throws IOException {
        TcpProtocol protocol = this.connector.getTcpProtocol();
        byte[] binaryData = data instanceof String ? data.toString().getBytes() : (data instanceof byte[] ? (byte[])data : Utility.objectToByteArray((Object)data));
        BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
        protocol.write(bos, binaryData);
        bos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage doSend(UMOEvent event) throws Exception {
        Socket socket = null;
        try {
            Object payload = event.getTransformedMessage();
            socket = this.initSocket(event.getEndpoint().getEndpointURI().getAddress());
            boolean syncReceive = event.getBooleanProperty("MULE_SYNC_RECEIVE", MuleManager.getConfiguration().isSynchronousReceive());
            this.write(socket, payload);
            if (syncReceive) {
                MuleMessage message;
                byte[] result;
                block10: {
                    try {
                        result = this.receive(socket, event.getTimeout());
                        if (result != null) break block10;
                        UMOMessage uMOMessage = null;
                        return uMOMessage;
                    }
                    catch (SocketTimeoutException e) {
                        logger.info((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + event.getEndpoint().getEndpointURI()));
                        UMOMessage uMOMessage = null;
                        return uMOMessage;
                    }
                }
                MuleMessage muleMessage = message = new MuleMessage(this.connector.getMessageAdapter(result));
                return muleMessage;
            }
            UMOMessage uMOMessage = event.getMessage();
            return uMOMessage;
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
    }

    protected byte[] receive(Socket socket, int timeout) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        if (timeout >= 0) {
            socket.setSoTimeout(timeout);
        }
        return this.connector.getTcpProtocol().read(dis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        Socket socket = null;
        try {
            MuleMessage message;
            byte[] result;
            block8: {
                socket = this.initSocket(endpointUri.getAddress());
                try {
                    result = this.receive(socket, (int)timeout);
                    if (result != null) break block8;
                    UMOMessage uMOMessage = null;
                    return uMOMessage;
                }
                catch (SocketTimeoutException e) {
                    logger.info((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + endpointUri));
                    UMOMessage uMOMessage = null;
                    return uMOMessage;
                }
            }
            MuleMessage muleMessage = message = new MuleMessage(this.connector.getMessageAdapter(result));
            return muleMessage;
        }
        finally {
            if (socket != null && !socket.isClosed()) {
                socket.close();
            }
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

