/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.tcp.TcpConnector;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.Utility;

public class TcpMessageDispatcher
extends AbstractMessageDispatcher {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$tcp$TcpMessageDispatcher == null ? (class$org$mule$providers$tcp$TcpMessageDispatcher = TcpMessageDispatcher.class$("org.mule.providers.tcp.TcpMessageDispatcher")) : class$org$mule$providers$tcp$TcpMessageDispatcher));
    private TcpConnector connector;
    static /* synthetic */ Class class$org$mule$providers$tcp$TcpMessageDispatcher;

    public TcpMessageDispatcher(TcpConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    protected Socket initSocket(String endpoint) throws IOException, URISyntaxException {
        URI uri = new URI(endpoint);
        int port = uri.getPort();
        InetAddress inetAddress = InetAddress.getByName(uri.getHost());
        Socket socket = this.createSocket(port, inetAddress);
        socket.setReuseAddress(true);
        socket.setReceiveBufferSize(this.connector.getBufferSize());
        socket.setSendBufferSize(this.connector.getBufferSize());
        socket.setSoTimeout(this.connector.getTimeout());
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doDispatch(UMOEvent event) throws Exception {
        Socket socket = null;
        try {
            Object payload = event.getTransformedMessage();
            socket = this.initSocket(event.getEndpoint().getEndpointURI().getAddress());
            this.write(socket, payload);
            Object var5_4 = null;
            if (socket == null) return;
            if (socket.isClosed()) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (socket == null || socket.isClosed()) throw throwable;
            socket.close();
            throw throwable;
        }
        socket.close();
    }

    protected Socket createSocket(int port, InetAddress inetAddress) throws IOException {
        return new Socket(inetAddress, port);
    }

    protected void write(Socket socket, Object data) throws IOException {
        TcpProtocol protocol = this.connector.getTcpProtocol();
        byte[] binaryData = data instanceof String ? data.toString().getBytes() : (data instanceof byte[] ? (byte[])data : Utility.objectToByteArray((Object)data));
        BufferedOutputStream bos = new BufferedOutputStream(socket.getOutputStream());
        protocol.write(bos, binaryData);
        bos.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage uMOMessage;
        Socket socket = null;
        try {
            Object payload = event.getTransformedMessage();
            socket = this.initSocket(event.getEndpoint().getEndpointURI().getAddress());
            this.write(socket, payload);
            if (this.useRemoteSync(event)) {
                byte[] result;
                block6: {
                    UMOMessage uMOMessage2;
                    try {
                        result = this.receive(socket, event.getEndpoint().getRemoteSyncTimeout());
                        if (result != null) break block6;
                        uMOMessage2 = null;
                    }
                    catch (SocketTimeoutException e) {
                        logger.info((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + event.getEndpoint().getEndpointURI()));
                        UMOMessage uMOMessage3 = null;
                        Object var7_12 = null;
                        if (socket == null) return uMOMessage3;
                        if (socket.isClosed()) return uMOMessage3;
                        socket.close();
                        return uMOMessage3;
                    }
                    Object var7_10 = null;
                    if (socket == null) return uMOMessage2;
                    if (socket.isClosed()) return uMOMessage2;
                    socket.close();
                    return uMOMessage2;
                }
                MuleMessage muleMessage = new MuleMessage(this.connector.getMessageAdapter(result));
                Object var7_11 = null;
                if (socket == null) return muleMessage;
                if (socket.isClosed()) return muleMessage;
                socket.close();
                return muleMessage;
            }
            uMOMessage = event.getMessage();
            Object var7_13 = null;
            if (socket == null) return uMOMessage;
            if (socket.isClosed()) return uMOMessage;
        }
        catch (Throwable throwable) {
            Object var7_14 = null;
            if (socket == null) throw throwable;
            if (socket.isClosed()) throw throwable;
            socket.close();
            throw throwable;
        }
        socket.close();
        return uMOMessage;
    }

    protected byte[] receive(Socket socket, int timeout) throws IOException {
        DataInputStream dis = new DataInputStream(new BufferedInputStream(socket.getInputStream()));
        if (timeout >= 0) {
            socket.setSoTimeout(timeout);
        }
        return this.connector.getTcpProtocol().read(dis);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        Socket socket = null;
        try {
            MuleMessage message;
            byte[] result;
            block5: {
                UMOMessage uMOMessage;
                socket = this.initSocket(endpointUri.getAddress());
                try {
                    result = this.receive(socket, (int)timeout);
                    if (result != null) break block5;
                    uMOMessage = null;
                }
                catch (SocketTimeoutException e) {
                    logger.info((Object)("Socket timed out normally while doing a synchronous receive on endpointUri: " + endpointUri));
                    UMOMessage uMOMessage2 = null;
                    Object var9_11 = null;
                    if (socket == null) return uMOMessage2;
                    if (socket.isClosed()) return uMOMessage2;
                    socket.close();
                    return uMOMessage2;
                }
                Object var9_9 = null;
                if (socket == null) return uMOMessage;
                if (socket.isClosed()) return uMOMessage;
                socket.close();
                return uMOMessage;
            }
            MuleMessage muleMessage = message = new MuleMessage(this.connector.getMessageAdapter(result));
            Object var9_10 = null;
            if (socket == null) return muleMessage;
            if (socket.isClosed()) return muleMessage;
            socket.close();
            return muleMessage;
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (socket == null) throw throwable;
            if (socket.isClosed()) throw throwable;
            socket.close();
            throw throwable;
        }
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

