/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import org.mule.config.i18n.Message;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.util.ClassHelper;

public class TcpConnector
extends AbstractServiceEnabledConnector {
    public static final int DEFAULT_SOCKET_TIMEOUT = 5000;
    public static final int DEFAULT_BUFFER_SIZE = 65536;
    public static final long DEFAULT_POLLING_FREQUENCY = 10L;
    public static final int DEFAULT_BACKLOG = 256;
    private int sendTimeout = 5000;
    private int receiveTimeout = 5000;
    private int bufferSize = 65536;
    private int backlog = 256;
    private String tcpProtocolClassName = (class$org$mule$providers$tcp$protocols$DefaultProtocol == null ? (class$org$mule$providers$tcp$protocols$DefaultProtocol = TcpConnector.class$("org.mule.providers.tcp.protocols.DefaultProtocol")) : class$org$mule$providers$tcp$protocols$DefaultProtocol).getName();
    private TcpProtocol tcpProtocol;
    private boolean sendSocketValid = false;
    private int receiveSocketsCount = 0;
    public static final int KEEP_RETRYING_INDEFINETLY = 0;
    private boolean keepSendSocketOpen = false;
    private int reconnectMillisecs = 10000;
    private int maxRetryCount = 0;
    static /* synthetic */ Class class$org$mule$providers$tcp$protocols$DefaultProtocol;

    public boolean isKeepSendSocketOpen() {
        return this.keepSendSocketOpen;
    }

    public void setKeepSendSocketOpen(boolean keepSendSocketOpen) {
        this.keepSendSocketOpen = keepSendSocketOpen;
    }

    public int getReconnectMillisecs() {
        return this.reconnectMillisecs;
    }

    public void setReconnectMillisecs(int reconnectMillisecs) {
        this.reconnectMillisecs = reconnectMillisecs;
    }

    public int getMaxRetryCount() {
        return this.maxRetryCount;
    }

    public void setMaxRetryCount(int maxRetryCount) {
        if (maxRetryCount >= 0) {
            this.maxRetryCount = maxRetryCount;
        }
    }

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        if (this.tcpProtocol == null) {
            try {
                this.tcpProtocol = (TcpProtocol)ClassHelper.instanciateClass((String)this.tcpProtocolClassName, null);
            }
            catch (Exception e) {
                throw new InitialisationException(new Message("tcp", 3), (Object)e);
            }
        }
    }

    public String getProtocol() {
        return "TCP";
    }

    public void setTimeout(int timeout) {
        this.setSendTimeout(timeout);
        this.setReceiveTimeout(timeout);
    }

    public int getSendTimeout() {
        return this.sendTimeout;
    }

    public void setSendTimeout(int timeout) {
        if (timeout < 0) {
            timeout = 5000;
        }
        this.sendTimeout = timeout;
    }

    public int getReceiveTimeout() {
        return this.receiveTimeout;
    }

    public void setReceiveTimeout(int timeout) {
        if (timeout < 0) {
            timeout = 5000;
        }
        this.receiveTimeout = timeout;
    }

    public boolean isSendSocketValid() {
        return this.sendSocketValid;
    }

    public void setSendSocketValid(boolean validity) {
        this.sendSocketValid = validity;
    }

    public boolean hasReceiveSockets() {
        return this.receiveSocketsCount > 0;
    }

    public synchronized void updateReceiveSocketsCount(boolean addSocket) {
        this.receiveSocketsCount = addSocket ? ++this.receiveSocketsCount : --this.receiveSocketsCount;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        if (bufferSize < 1) {
            bufferSize = 65536;
        }
        this.bufferSize = bufferSize;
    }

    public int getBacklog() {
        return this.backlog;
    }

    public void setBacklog(int backlog) {
        this.backlog = backlog;
    }

    public TcpProtocol getTcpProtocol() {
        return this.tcpProtocol;
    }

    public void setTcpProtocol(TcpProtocol tcpProtocol) {
        this.tcpProtocol = tcpProtocol;
    }

    public String getTcpProtocolClassName() {
        return this.tcpProtocolClassName;
    }

    public void setTcpProtocolClassName(String protocolClassName) {
        this.tcpProtocolClassName = protocolClassName;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

