/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.tcp;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.URI;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.ResponseOutputStream;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.tcp.TcpConnector;
import org.mule.providers.tcp.TcpProtocol;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.lifecycle.DisposeException;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class TcpMessageReceiver
extends AbstractMessageReceiver
implements Work {
    protected ServerSocket serverSocket = null;

    public TcpMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint);
    }

    public void doConnect() throws ConnectException {
        this.disposing.set(false);
        URI uri = this.endpoint.getEndpointURI().getUri();
        try {
            this.serverSocket = this.createSocket(uri);
        }
        catch (Exception e) {
            throw new ConnectException(new Message("tcp", 1, (Object)uri), (Throwable)e, (Object)this);
        }
        try {
            this.getWorkManager().scheduleWork((Work)this, Long.MAX_VALUE, null, null);
        }
        catch (WorkException e) {
            throw new ConnectException(new Message(151), (Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws ConnectException {
        this.disposing.set(true);
        try {
            this.serverSocket.close();
        }
        catch (IOException e) {
            this.logger.warn((Object)("Failed to close server socket: " + e.getMessage()), (Throwable)e);
        }
    }

    protected ServerSocket createSocket(URI uri) throws Exception {
        InetAddress inetAddress;
        String host = uri.getHost();
        int backlog = ((TcpConnector)this.connector).getBacklog();
        if (host == null || host.length() == 0) {
            host = "localhost";
        }
        if ((inetAddress = InetAddress.getByName(host)).equals(InetAddress.getLocalHost()) || inetAddress.isLoopbackAddress() || host.trim().equals("localhost")) {
            return new ServerSocket(uri.getPort(), backlog);
        }
        return new ServerSocket(uri.getPort(), backlog, inetAddress);
    }

    public ServerSocket getServerSocket() {
        return this.serverSocket;
    }

    public void run() {
        while (!this.disposing.get()) {
            Socket socket;
            block8: {
                if (!this.connector.isStarted() || this.disposing.get()) continue;
                socket = null;
                try {
                    socket = this.serverSocket.accept();
                    TcpConnector connector = (TcpConnector)this.connector;
                    socket.setReceiveBufferSize(connector.getBufferSize());
                    socket.setSendBufferSize(connector.getBufferSize());
                    socket.setSoTimeout(connector.getReceiveTimeout());
                    this.logger.trace((Object)("Server socket Accepted on: " + this.serverSocket.getLocalPort()));
                }
                catch (InterruptedIOException iie) {
                    this.logger.debug((Object)("Interupted IO doing serverSocket.accept: " + iie.getMessage()));
                }
                catch (Exception e) {
                    if (this.connector.isDisposed() || this.disposing.get()) break block8;
                    this.logger.warn((Object)("Accept failed on socket: " + e), (Throwable)e);
                    this.handleException((Exception)new ConnectException((Throwable)e, (Object)this));
                }
            }
            if (socket == null) continue;
            try {
                Work work = this.createWork(socket);
                try {
                    this.getWorkManager().scheduleWork(work, 0L, null, null);
                }
                catch (WorkException e) {
                    this.logger.error((Object)("Tcp Server receiver Work was not processed: " + e.getMessage()), (Throwable)e);
                }
            }
            catch (SocketException e) {
                this.handleException(e);
            }
        }
    }

    public void release() {
    }

    public void doDispose() {
        try {
            if (this.serverSocket != null && !this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
            this.serverSocket = null;
        }
        catch (Exception e) {
            this.logger.error((Object)new DisposeException(new Message("tcp", 2), (Object)e));
        }
        this.logger.info((Object)"Closed Tcp port");
    }

    protected Work createWork(Socket socket) throws SocketException {
        return new TcpWorker(socket);
    }

    protected class TcpWorker
    implements Work,
    Disposable {
        protected Socket socket = null;
        protected DataInputStream dataIn;
        protected DataOutputStream dataOut;
        protected AtomicBoolean closed = new AtomicBoolean(false);
        protected TcpProtocol protocol;

        public TcpWorker(Socket socket) {
            this.socket = socket;
            TcpConnector tcpConnector = (TcpConnector)TcpMessageReceiver.this.connector;
            this.protocol = tcpConnector.getTcpProtocol();
            tcpConnector.updateReceiveSocketsCount(true);
        }

        public void release() {
            this.dispose();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void dispose() {
            this.closed.set(true);
            try {
                if (this.socket != null && !this.socket.isClosed()) {
                    TcpMessageReceiver.this.logger.debug((Object)("Closing listener: " + this.socket.getLocalSocketAddress().toString()));
                    this.socket.shutdownInput();
                    this.socket.shutdownOutput();
                    this.socket.close();
                }
            }
            catch (IOException e) {
                TcpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e));
            }
            finally {
                ((TcpConnector)TcpMessageReceiver.this.connector).updateReceiveSocketsCount(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.dataIn = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
                this.dataOut = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
                while (!this.socket.isClosed() && !TcpMessageReceiver.this.disposing.get()) {
                    byte[] b = this.protocol.read(this.dataIn);
                    if (b == null) {
                        break;
                    }
                    byte[] result = this.processData(b);
                    if (result != null) {
                        this.protocol.write(this.dataOut, result);
                    }
                    this.dataOut.flush();
                }
            }
            catch (Exception e) {
                TcpMessageReceiver.this.handleException(e);
            }
            finally {
                this.dispose();
            }
        }

        protected byte[] processData(byte[] data) throws Exception {
            UMOMessageAdapter adapter = TcpMessageReceiver.this.connector.getMessageAdapter((Object)data);
            ResponseOutputStream os = new ResponseOutputStream(this.socket.getOutputStream(), this.socket);
            UMOMessage returnMessage = TcpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage((Object)adapter), TcpMessageReceiver.this.endpoint.isSynchronous(), (OutputStream)os);
            if (returnMessage != null) {
                return returnMessage.getPayloadAsBytes();
            }
            return null;
        }
    }
}

