/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.udp;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.UnknownHostException;
import org.mule.DisposeException;
import org.mule.InitialisationException;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.udp.UdpConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.Disposable;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class UdpMessageReceiver
extends AbstractMessageReceiver
implements Runnable {
    protected DatagramSocket socket = null;
    protected PooledExecutor threadPool;
    protected InetAddress inetAddress;
    protected int bufferSize;
    private URI uri;
    private Thread worker;

    public UdpMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this.create((UMOConnector)connector, component, endpoint);
        this.bufferSize = ((UdpConnector)connector).getBufferSize();
        this.threadPool = connector.getReceiverThreadingProfile().createPool(connector.getName());
        this.uri = endpoint.getEndpointURI().getUri();
        try {
            this.inetAddress = InetAddress.getByName(this.uri.getHost());
        }
        catch (UnknownHostException e) {
            throw new InitialisationException("Failed to locate host: " + e.getMessage(), (Throwable)e);
        }
        this.connect(this.uri);
        this.worker = new Thread(this);
        this.worker.start();
    }

    protected void connect(URI uri) throws InitialisationException {
        this.logger.info((Object)("Attempting to connect to: " + uri.toString()));
        int count = ((UdpConnector)this.connector).getRetryCount();
        long freq = ((UdpConnector)this.connector).getRetryFrequency();
        ++count;
        for (int i = 0; i < count; ++i) {
            try {
                this.socket = this.createSocket(uri, this.inetAddress);
                this.socket.setSoTimeout(((UdpConnector)this.connector).getTimeout());
                this.socket.setReceiveBufferSize(this.bufferSize);
                this.socket.setSendBufferSize(this.bufferSize);
                this.logger.info((Object)("Connected to: " + uri.toString()));
                break;
            }
            catch (Exception e) {
                this.logger.debug((Object)("Failed to bind to uri: " + uri), (Throwable)e);
                if (i < count - 1) {
                    try {
                        Thread.sleep(freq);
                    }
                    catch (InterruptedException ignore) {}
                    continue;
                }
                throw new InitialisationException("Unable to bind to uri: " + uri + ". Reason: " + e);
            }
        }
    }

    protected DatagramSocket createSocket(URI uri, InetAddress inetAddress) throws IOException {
        return new DatagramSocket(uri.getPort(), inetAddress);
    }

    public DatagramSocket getSocket() {
        return this.socket;
    }

    protected DatagramPacket createPacket() {
        DatagramPacket packet = new DatagramPacket(new byte[this.bufferSize], this.bufferSize);
        if (this.uri.getPort() > 0) {
            packet.setPort(this.uri.getPort());
        }
        packet.setAddress(this.inetAddress);
        return packet;
    }

    public void run() {
        while (!this.disposing.get()) {
            if (!this.connector.isStarted()) continue;
            try {
                DatagramPacket packet = this.createPacket();
                try {
                    this.socket.receive(packet);
                    this.logger.trace((Object)("Received packet on: " + this.inetAddress.toString()));
                    Runnable worker = this.createWorker(packet);
                    try {
                        this.threadPool.execute(worker);
                    }
                    catch (InterruptedException e) {
                        this.logger.error((Object)("Udp receiver interrupted: " + e.getMessage()), (Throwable)e);
                    }
                }
                catch (SocketTimeoutException socketTimeoutException) {
                }
            }
            catch (Exception e) {
                if (this.connector.isDisposed() || this.disposing.get()) continue;
                this.logger.debug((Object)("Accept failed on socket: " + e), (Throwable)e);
                this.handleException(null, e);
            }
        }
    }

    public void doDispose() throws UMOException {
        try {
            this.threadPool.shutdownNow();
            this.socket.close();
        }
        catch (Exception e) {
            throw new DisposeException("Failed to close udp socket: " + e.getMessage(), (Throwable)e);
        }
        this.logger.info((Object)("Closed Udp connection: " + this.uri));
    }

    protected Runnable createWorker(DatagramPacket packet) throws IOException {
        return new UdpWorker(new DatagramSocket(0), packet);
    }

    protected class UdpWorker
    implements Runnable,
    Disposable {
        private DatagramSocket socket = null;
        private DatagramPacket packet;

        public UdpWorker(DatagramSocket socket, DatagramPacket packet) {
            this.socket = socket;
            this.packet = packet;
        }

        public void dispose() {
            if (this.socket != null) {
                this.socket.close();
            }
            this.socket = null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block9: {
                block8: {
                    UMOMessageAdapter adapter = UdpMessageReceiver.this.connector.getMessageAdapter((Object)this.packet);
                    UMOMessage returnMessage = UdpMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), UdpMessageReceiver.this.endpoint.isSynchronous());
                    if (returnMessage == null) break block8;
                    byte[] data = returnMessage.getPayloadAsBytes();
                    DatagramPacket result = new DatagramPacket(data, data.length, this.packet.getAddress(), this.packet.getPort());
                    this.socket.send(result);
                }
                Object var6_6 = null;
                try {
                    this.socket.close();
                }
                catch (Exception e2) {
                    UdpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e2));
                }
                break block9;
                {
                    catch (Exception e) {
                        UdpMessageReceiver.this.handleException("Failed to process Udp Request on: " + (this.socket != null ? this.socket.getInetAddress().toString() : "null"), e);
                        Object var6_7 = null;
                        try {
                            this.socket.close();
                        }
                        catch (Exception e2) {
                            UdpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e2));
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        this.socket.close();
                    }
                    catch (Exception e2) {
                        UdpMessageReceiver.this.logger.error((Object)("Socket close failed with: " + e2));
                    }
                    throw throwable;
                }
            }
        }
    }
}

