/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import EDU.oswego.cs.dl.util.concurrent.ConcurrentHashMap;
import java.util.Iterator;
import org.mule.MuleManager;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.vm.VMMessageReceiver;
import org.mule.routing.filters.WildcardFilter;
import org.mule.umo.MessagingException;
import org.mule.umo.UMOComponent;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassHelper;
import org.mule.util.queue.BoundedPersistentQueue;

public class VMConnector
extends AbstractServiceEnabledConnector {
    private boolean queueEvents = false;
    private int maxQueues = 16;
    private ConcurrentHashMap queues = null;
    private QueueProfile queueProfile;
    private Class adapterClass = null;

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        if (this.queueEvents) {
            this.queues = new ConcurrentHashMap(this.maxQueues);
            if (this.queueProfile == null) {
                this.queueProfile = MuleManager.getConfiguration().getQueueProfile();
            }
        }
        try {
            this.adapterClass = ClassHelper.loadClass((String)this.serviceDescriptor.getMessageAdapter(), ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(new Message(58, (Object)("Message Adapter: " + this.serviceDescriptor.getMessageAdapter())), (Object)e);
        }
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        BoundedPersistentQueue queue = null;
        if (this.queueEvents) {
            queue = this.queueProfile.createQueue(endpoint.getEndpointURI().getAddress());
            this.queues.put((Object)endpoint.getEndpointURI().getAddress(), (Object)queue);
        }
        return this.serviceDescriptor.createMessageReceiver((UMOConnector)this, component, endpoint, new Object[]{queue});
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        if (message == null) {
            throw new MessageTypeNotSupportedException(null, this.adapterClass);
        }
        if (message instanceof MuleMessage) {
            return ((MuleMessage)message).getAdapter();
        }
        if (message instanceof UMOMessageAdapter) {
            return (UMOMessageAdapter)message;
        }
        throw new MessageTypeNotSupportedException(message, this.adapterClass);
    }

    public String getProtocol() {
        return "VM";
    }

    protected void disposeConnector() {
        if (this.queues != null) {
            Iterator iterator = this.queues.values().iterator();
            while (iterator.hasNext()) {
                BoundedPersistentQueue queue = (BoundedPersistentQueue)iterator.next();
                queue.dispose();
            }
            this.queues.clear();
        }
    }

    public boolean isQueueEvents() {
        return this.queueEvents;
    }

    public void setQueueEvents(boolean queueEvents) {
        this.queueEvents = queueEvents;
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public void setMaxQueues(int maxQueues) {
        this.maxQueues = maxQueues;
    }

    BoundedPersistentQueue getQueue(String endpoint) {
        return (BoundedPersistentQueue)this.queues.get((Object)endpoint);
    }

    VMMessageReceiver getReceiver(UMOEndpointURI endpointUri) throws EndpointException {
        return (VMMessageReceiver)this.getRecieverByEndpoint(endpointUri);
    }

    BoundedPersistentQueue createQueue(String endpoint) throws InitialisationException {
        BoundedPersistentQueue queue = (BoundedPersistentQueue)this.queues.get((Object)endpoint);
        if (queue != null) {
            return queue;
        }
        queue = this.queueProfile.createQueue(endpoint);
        this.queues.put((Object)endpoint, (Object)queue);
        return queue;
    }

    protected UMOMessageReceiver getRecieverByEndpoint(UMOEndpointURI endpointUri) throws EndpointException {
        UMOMessageReceiver receiver;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Lookng up vm reciever for address: " + endpointUri.toString()));
        }
        if ((receiver = (UMOMessageReceiver)this.receivers.get((Object)endpointUri.getAddress())) != null) {
            this.logger.debug((Object)("Found exact receiver match on endpointUri: " + endpointUri));
            return receiver;
        }
        Iterator iterator = this.receivers.values().iterator();
        while (iterator.hasNext()) {
            receiver = (UMOMessageReceiver)iterator.next();
            String filterAddress = receiver.getEndpointURI().getAddress();
            WildcardFilter filter = new WildcardFilter(filterAddress);
            if (!filter.accept((Object)endpointUri.getAddress())) continue;
            receiver.getEndpoint().setEndpointURI((UMOEndpointURI)new MuleEndpointURI(endpointUri, filterAddress));
            this.logger.debug((Object)("Found receiver match on endpointUri: " + receiver.getEndpointURI() + " against " + endpointUri));
            return receiver;
        }
        this.logger.debug((Object)("No receiver found for endpointUri: " + endpointUri));
        return null;
    }
}

