/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.queue.BoundedPersistentQueue;

public class VMMessageReceiver
extends AbstractMessageReceiver
implements Runnable {
    private BoundedPersistentQueue queue;
    private Thread worker;
    private Object lock = new Object();

    public VMMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint, BoundedPersistentQueue queue) throws InitialisationException {
        this.create(connector, component, endpoint);
        this.queue = queue;
        if (queue != null) {
            this.worker = new Thread(this);
            this.worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(UMOEvent event) throws UMOException {
        block9: {
            if (this.queue != null) {
                try {
                    BoundedPersistentQueue boundedPersistentQueue = this.queue;
                    synchronized (boundedPersistentQueue) {
                        this.queue.put((Object)event);
                        break block9;
                    }
                }
                catch (InterruptedException e) {
                    throw new MuleException(new Message(106, (Object)this.endpoint.getEndpointURI()), (Throwable)e);
                }
            }
            UMOMessageAdapter adapter = this.connector.getMessageAdapter((Object)new MuleMessage(event.getTransformedMessage(), event.getProperties()));
            MuleMessage message = new MuleMessage(adapter);
            Object object = this.lock;
            synchronized (object) {
                this.routeMessage((UMOMessage)message, event.isSynchronous());
            }
        }
    }

    public Object onCall(UMOEvent event) throws UMOException {
        UMOMessageAdapter adapter = this.connector.getMessageAdapter((Object)new MuleMessage(event.getTransformedMessage(), event.getProperties()));
        return this.routeMessage((UMOMessage)new MuleMessage(adapter), event.isSynchronous());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        while (!this.disposing.get()) {
            Object var4_5;
            if (!this.connector.isStarted()) continue;
            UMOEvent event = null;
            try {
                try {
                    try {
                        event = (UMOEvent)this.queue.take();
                        UMOMessageAdapter adapter = this.connector.getMessageAdapter((Object)new MuleMessage(event.getTransformedMessage(), event.getProperties()));
                        this.routeMessage((UMOMessage)new MuleMessage(adapter), event.isSynchronous());
                    }
                    catch (InterruptedException e) {
                    }
                    var4_5 = null;
                    if (event == null) continue;
                }
                catch (Exception e) {
                    this.logger.error((Object)("Failed to dispatch event from VM receiver: " + e.getMessage()), (Throwable)e);
                    if (e instanceof UMOException) {
                        this.connector.getExceptionListener().exceptionThrown(e);
                    } else {
                        this.connector.getExceptionListener().exceptionThrown((Exception)new DispatchException(event.getMessage(), event.getEndpoint(), (Throwable)e));
                    }
                    var4_5 = null;
                    if (event == null) continue;
                    this.queue.remove((Object)event);
                    continue;
                }
            }
            catch (Throwable throwable) {
                var4_5 = null;
                if (event != null) {
                    this.queue.remove((Object)event);
                }
                throw throwable;
            }
            this.queue.remove((Object)event);
        }
        return;
    }

    BoundedPersistentQueue getQueue() {
        return this.queue;
    }

    public void doDispose() {
        if (this.worker != null) {
            this.worker.interrupt();
        }
        this.worker = null;
    }
}

