/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import java.util.Iterator;
import org.mule.MuleManager;
import org.mule.config.QueueProfile;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.impl.endpoint.MuleEndpointURI;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.providers.vm.VMMessageReceiver;
import org.mule.routing.filters.WildcardFilter;
import org.mule.transaction.TransactionCoordination;
import org.mule.umo.MessagingException;
import org.mule.umo.TransactionException;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOTransaction;
import org.mule.umo.endpoint.EndpointException;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.umo.provider.UMOMessageReceiver;
import org.mule.util.ClassHelper;
import org.mule.util.queue.QueueManager;
import org.mule.util.queue.QueueSession;

public class VMConnector
extends AbstractServiceEnabledConnector {
    private boolean queueEvents = false;
    private int maxQueues = 16;
    private QueueProfile queueProfile;
    private Class adapterClass = null;

    public void doInitialise() throws InitialisationException {
        super.doInitialise();
        if (this.queueEvents && this.queueProfile == null) {
            this.queueProfile = MuleManager.getConfiguration().getQueueProfile();
        }
        try {
            this.adapterClass = ClassHelper.loadClass((String)this.serviceDescriptor.getMessageAdapter(), ((Object)((Object)this)).getClass());
        }
        catch (ClassNotFoundException e) {
            throw new InitialisationException(new Message(58, (Object)("Message Adapter: " + this.serviceDescriptor.getMessageAdapter())), (Object)e);
        }
    }

    public UMOMessageReceiver createReceiver(UMOComponent component, UMOEndpoint endpoint) throws Exception {
        if (this.queueEvents) {
            this.queueProfile.configureQueue(endpoint.getEndpointURI().getAddress());
        }
        return this.serviceDescriptor.createMessageReceiver((UMOConnector)this, component, endpoint);
    }

    public UMOMessageAdapter getMessageAdapter(Object message) throws MessagingException {
        if (message == null) {
            throw new MessageTypeNotSupportedException(null, this.adapterClass);
        }
        if (message instanceof MuleMessage) {
            return ((MuleMessage)message).getAdapter();
        }
        if (message instanceof UMOMessageAdapter) {
            return (UMOMessageAdapter)message;
        }
        throw new MessageTypeNotSupportedException(message, this.adapterClass);
    }

    public String getProtocol() {
        return "VM";
    }

    protected void doDispose() {
    }

    public boolean isQueueEvents() {
        return this.queueEvents;
    }

    public void setQueueEvents(boolean queueEvents) {
        this.queueEvents = queueEvents;
    }

    public QueueProfile getQueueProfile() {
        return this.queueProfile;
    }

    public void setQueueProfile(QueueProfile queueProfile) {
        this.queueProfile = queueProfile;
    }

    public void setMaxQueues(int maxQueues) {
        this.maxQueues = maxQueues;
    }

    VMMessageReceiver getReceiver(UMOEndpointURI endpointUri) throws EndpointException {
        return (VMMessageReceiver)this.getReceiverByEndpoint(endpointUri);
    }

    QueueSession getQueueSession() throws InitialisationException {
        QueueManager qm = MuleManager.getInstance().getQueueManager();
        UMOTransaction tx = TransactionCoordination.getInstance().getTransaction();
        if (tx != null && tx.hasResource((Object)qm)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)"Retrieving queue session from current transaction");
            }
            return (QueueSession)tx.getResource((Object)qm);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)"Retrieving new queue session from queue manager");
        }
        QueueSession session = qm.getQueueSession();
        if (tx != null) {
            this.logger.debug((Object)"Binding queue session to current transaction");
            try {
                tx.bindResource((Object)qm, (Object)session);
            }
            catch (TransactionException e) {
                throw new RuntimeException("Could not bind queue session to current transaction", e);
            }
        }
        return session;
    }

    protected UMOMessageReceiver getReceiverByEndpoint(UMOEndpointURI endpointUri) throws EndpointException {
        UMOMessageReceiver receiver;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Looking up vm receiver for address: " + endpointUri.toString()));
        }
        if ((receiver = (UMOMessageReceiver)this.receivers.get((Object)endpointUri.getAddress())) != null) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found exact receiver match on endpointUri: " + endpointUri));
            }
            return receiver;
        }
        Iterator iterator = this.receivers.values().iterator();
        while (iterator.hasNext()) {
            receiver = (UMOMessageReceiver)iterator.next();
            String filterAddress = receiver.getEndpointURI().getAddress();
            WildcardFilter filter = new WildcardFilter(filterAddress);
            if (!filter.accept((Object)endpointUri.getAddress())) continue;
            receiver.getEndpoint().setEndpointURI((UMOEndpointURI)new MuleEndpointURI(endpointUri, filterAddress));
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Found receiver match on endpointUri: " + receiver.getEndpointURI() + " against " + endpointUri));
            }
            return receiver;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("No receiver found for endpointUri: " + endpointUri));
        }
        return null;
    }

    public boolean isRemoteSyncEnabled() {
        return true;
    }
}

