/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.config.i18n.Message;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.vm.VMConnector;
import org.mule.providers.vm.VMMessageReceiver;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.NoReceiverForEndpointException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageDispatcher
extends AbstractMessageDispatcher {
    private static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$vm$VMMessageDispatcher == null ? (class$org$mule$providers$vm$VMMessageDispatcher = VMMessageDispatcher.class$("org.mule.providers.vm.VMMessageDispatcher")) : class$org$mule$providers$vm$VMMessageDispatcher));
    private VMConnector connector;
    static /* synthetic */ Class class$org$mule$providers$vm$VMMessageDispatcher;

    public VMMessageDispatcher(VMConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        if (!this.connector.isQueueEvents()) {
            throw new UnsupportedOperationException("Receive only supported on the VM Queue Connector");
        }
        QueueSession queueSession = null;
        queueSession = this.connector.getQueueSession();
        Queue queue = queueSession.getQueue(endpointUri.getAddress());
        if (queue == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No queue with name " + endpointUri.getAddress()));
            }
            return null;
        }
        UMOEvent event = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Waiting for a message on " + endpointUri.getAddress()));
        }
        try {
            event = (UMOEvent)queue.poll(timeout);
        }
        catch (InterruptedException e) {
            logger.error((Object)("Failed to receive event from queue: " + endpointUri));
        }
        if (event != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event received: " + event));
            }
            return event.getMessage();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No event received after " + timeout + " ms"));
        }
        return null;
    }

    public void doDispatch(UMOEvent event) throws Exception {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        if (endpointUri == null) {
            throw new DispatchException(new Message(45, (Object)"Endpoint"), event.getMessage(), event.getEndpoint());
        }
        if (this.connector.isQueueEvents()) {
            QueueSession session = this.connector.getQueueSession();
            Queue queue = session.getQueue(endpointUri.getAddress());
            queue.put((Object)event);
        } else {
            VMMessageReceiver receiver = this.connector.getReceiver(event.getEndpoint().getEndpointURI());
            if (receiver == null) {
                logger.warn((Object)("No receiver for endpointUri: " + event.getEndpoint().getEndpointURI()));
                return;
            }
            receiver.onEvent(event);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dispatched Event on endpointUri: " + endpointUri));
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        UMOMessage retMessage = null;
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        VMMessageReceiver receiver = this.connector.getReceiver(endpointUri);
        if (receiver == null) {
            if (this.connector.isQueueEvents()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Writing to queue as there is no receiver on connector: " + this.connector.getName() + ", for endpointUri: " + event.getEndpoint().getEndpointURI()));
                }
                this.doDispatch(event);
                return null;
            }
            throw new NoReceiverForEndpointException(new Message(118, (Object)this.connector.getName(), (Object)event.getEndpoint().getEndpointURI()));
        }
        retMessage = (UMOMessage)receiver.onCall(event);
        logger.debug((Object)("sent event on endpointUri: " + event.getEndpoint().getEndpointURI()));
        return retMessage;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

