/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import java.util.List;
import org.mule.MuleException;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.TransactedPollingMessageReceiver;
import org.mule.providers.vm.VMConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageReceiver
extends TransactedPollingMessageReceiver {
    private VMConnector connector;
    private Object lock = new Object();

    public VMMessageReceiver(UMOConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super(connector, component, endpoint, new Long(10L));
        this.connector = (VMConnector)connector;
        this.receiveMessagesInTransaction = endpoint.getTransactionConfig().isTransacted();
    }

    public void doConnect() throws Exception {
        if (this.connector.isQueueEvents()) {
            QueueSession queueSession = this.connector.getQueueSession();
            queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
        }
    }

    public void doDisconnect() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onEvent(UMOEvent event) throws UMOException {
        if (this.connector.isQueueEvents()) {
            QueueSession queueSession = this.connector.getQueueSession();
            Queue queue = queueSession.getQueue(this.endpoint.getEndpointURI().getAddress());
            try {
                queue.put((Object)event);
            }
            catch (InterruptedException e) {
                throw new MuleException(new Message(106, (Object)this.endpoint.getEndpointURI()), (Throwable)e);
            }
        }
        MuleMessage msg = new MuleMessage(event.getTransformedMessage(), event.getProperties());
        Object object = this.lock;
        synchronized (object) {
            this.routeMessage((UMOMessage)msg);
        }
    }

    public Object onCall(UMOEvent event) throws UMOException {
        return this.routeMessage((UMOMessage)new MuleMessage(event.getTransformedMessage(), event.getProperties(), event.getMessage()), event.isSynchronous());
    }

    protected List getMessages() throws Exception {
        QueueSession qs = this.connector.getQueueSession();
        Queue queue = qs.getQueue(this.endpoint.getEndpointURI().getAddress());
        UMOEvent event = (UMOEvent)queue.take();
        this.routeMessage((UMOMessage)new MuleMessage(event.getTransformedMessage(), event.getProperties()));
        return null;
    }

    protected void processMessage(Object msg) throws Exception {
    }
}

