/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.vm;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.mule.MuleManager;
import org.mule.config.i18n.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.streaming.StreamMessageAdapter;
import org.mule.providers.vm.VMConnector;
import org.mule.providers.vm.VMMessageReceiver;
import org.mule.transformers.simple.SerializableToByteArray;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.endpoint.UMOImmutableEndpoint;
import org.mule.umo.provider.DispatchException;
import org.mule.umo.provider.NoReceiverForEndpointException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;
import org.mule.util.queue.Queue;
import org.mule.util.queue.QueueSession;

public class VMMessageDispatcher
extends AbstractMessageDispatcher {
    private static transient Log logger = LogFactory.getLog((Class)VMMessageDispatcher.class);
    private VMConnector connector;
    private SerializableToByteArray serializableToByteArray;

    public VMMessageDispatcher(UMOImmutableEndpoint endpoint) {
        super(endpoint);
        this.connector = (VMConnector)endpoint.getConnector();
        this.serializableToByteArray = new SerializableToByteArray();
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    protected UMOMessage doReceive(UMOImmutableEndpoint endpoint, long timeout) throws Exception {
        if (!this.connector.isQueueEvents()) {
            throw new UnsupportedOperationException("Receive only supported on the VM Queue Connector");
        }
        QueueSession queueSession = null;
        queueSession = this.connector.getQueueSession();
        Queue queue = queueSession.getQueue(endpoint.getEndpointURI().getAddress());
        if (queue == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No queue with name " + endpoint.getEndpointURI().getAddress()));
            }
            return null;
        }
        UMOEvent event = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Waiting for a message on " + endpoint.getEndpointURI().getAddress()));
        }
        try {
            event = (UMOEvent)queue.poll(timeout);
        }
        catch (InterruptedException e) {
            logger.error((Object)("Failed to receive event from queue: " + endpoint.getEndpointURI()));
        }
        if (event != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Event received: " + event));
            }
            return event.getMessage();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("No event received after " + timeout + " ms"));
        }
        return null;
    }

    protected void doDispatch(UMOEvent event) throws Exception {
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        if (endpointUri == null) {
            throw new DispatchException(new Message(45, (Object)"Endpoint"), event.getMessage(), event.getEndpoint());
        }
        if (this.connector.isQueueEvents()) {
            QueueSession session = this.connector.getQueueSession();
            Queue queue = session.getQueue(endpointUri.getAddress());
            queue.put((Object)event);
        } else {
            VMMessageReceiver receiver = this.connector.getReceiver(event.getEndpoint().getEndpointURI());
            if (receiver == null) {
                logger.warn((Object)("No receiver for endpointUri: " + event.getEndpoint().getEndpointURI()));
                return;
            }
            if (event.isStreaming()) {
                StreamMessageAdapter sma = (StreamMessageAdapter)event.getMessage().getAdapter();
                sma.setIn((InputStream)new PipedInputStream());
                PipedOutputStream out = new PipedOutputStream((PipedInputStream)sma.getInput());
                sma.write(event, (OutputStream)out);
            }
            receiver.onEvent(event);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("dispatched Event on endpointUri: " + endpointUri));
        }
    }

    protected UMOMessage doSend(UMOEvent event) throws Exception {
        StreamMessageAdapter sma;
        UMOMessage retMessage = null;
        UMOEndpointURI endpointUri = event.getEndpoint().getEndpointURI();
        VMMessageReceiver receiver = this.connector.getReceiver(endpointUri);
        if (receiver == null) {
            if (this.connector.isQueueEvents()) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Writing to queue as there is no receiver on connector: " + this.connector.getName() + ", for endpointUri: " + event.getEndpoint().getEndpointURI()));
                }
                this.doDispatch(event);
                return null;
            }
            throw new NoReceiverForEndpointException(new Message(118, (Object)this.connector.getName(), (Object)event.getEndpoint().getEndpointURI()));
        }
        if (event.isStreaming()) {
            sma = (StreamMessageAdapter)event.getMessage().getAdapter();
            sma.setIn((InputStream)new PipedInputStream());
            PipedOutputStream out = new PipedOutputStream((PipedInputStream)sma.getInput());
            sma.write(event, (OutputStream)out);
        }
        retMessage = (UMOMessage)receiver.onCall(event);
        if (event.isStreaming() && retMessage != null) {
            sma = (StreamMessageAdapter)event.getMessage().getAdapter();
            sma.setResponse((InputStream)new ByteArrayInputStream((byte[])this.serializableToByteArray.transform(retMessage.getPayload())));
            retMessage = new MuleMessage((Object)sma, (UMOMessageAdapter)retMessage);
        }
        logger.debug((Object)("sent event on endpointUri: " + event.getEndpoint().getEndpointURI()));
        return retMessage;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    protected void doDispose() {
    }

    protected void doConnect(UMOImmutableEndpoint endpoint) throws Exception {
        if (this.connector.isQueueEvents()) {
            MuleManager.getConfiguration().getQueueProfile().configureQueue(endpoint.getEndpointURI().getAddress());
        }
    }

    protected void doDisconnect() throws Exception {
    }
}

