/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import java.io.IOException;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.provider.UMOConnector;

public class XmppMessageDispatcher
extends AbstractMessageDispatcher {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$xmpp$XmppMessageDispatcher == null ? (class$org$mule$providers$xmpp$XmppMessageDispatcher = XmppMessageDispatcher.class$("org.mule.providers.xmpp.XmppMessageDispatcher")) : class$org$mule$providers$xmpp$XmppMessageDispatcher));
    private XmppConnector connector;
    private SynchronizedBoolean initialized = new SynchronizedBoolean(false);
    private XMPPConnection xmppConnection = null;
    private static int connectionCount = 0;
    static /* synthetic */ Class class$org$mule$providers$xmpp$XmppMessageDispatcher;

    public XmppMessageDispatcher(XmppConnector connector) {
        super((AbstractConnector)connector);
        this.connector = connector;
    }

    protected synchronized int getNextMuleId() {
        return connectionCount++;
    }

    protected synchronized void initialise(String endpoint) throws IOException, URISyntaxException {
        if (!this.initialized.get()) {
            XmppConnector cnn = this.connector;
            String serverName = cnn.getServerName();
            String userName = cnn.getUsername();
            String login = cnn.getPassword();
            userName = "muleout" + new Integer(this.getNextMuleId()).toString();
            XMPPException xmppex = null;
            try {
                try {
                    this.xmppConnection = new XMPPConnection(serverName);
                    AccountManager accManager = new AccountManager(this.xmppConnection);
                    accManager.createAccount(userName, login);
                }
                catch (XMPPException ex) {
                    logger.warn((Object)"*** mule outbound account already exists ***");
                    xmppex = ex;
                }
                logger.warn((Object)("logging in: uid=" + userName + " pw=" + login + "\n"));
                if (!this.xmppConnection.isConnected()) {
                    logger.warn((Object)"******************************************");
                    logger.warn((Object)"   FAILED TO LOG INTO SERVER!!!");
                    logger.warn((Object)("   previous exception was: " + xmppex.getMessage()));
                    logger.warn((Object)"******************************************");
                }
                this.xmppConnection.login(userName, login);
                this.initialized.set(true);
            }
            catch (XMPPException e) {
                logger.error((Object)("error initailizing: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public void doDispatch(UMOEvent event) throws Exception {
        logger.info((Object)"in doDispatch()");
        this.initialise(event.getEndpoint().getEndpointURI().getAddress());
        try {
            Message message = (Message)event.getTransformedMessage();
            while (!this.xmppConnection.isConnected() && !this.initialized.get()) {
                this.initialise(null);
                Thread.sleep(150L);
            }
            try {
                this.xmppConnection.createChat(message.getTo()).sendMessage(message);
            }
            catch (IllegalStateException isex) {
                logger.fatal((Object)"************************************");
                logger.fatal((Object)"BIG PROBLEMS: ", (Throwable)isex);
                logger.fatal((Object)"************************************");
                System.exit(0);
            }
        }
        catch (ClassCastException ccex) {
            logger.error((Object)"something bad happened: ", (Throwable)ccex);
            logger.error((Object)("object was a :" + event.getTransformedMessage().getClass().getName()));
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.doDispatch(event);
        return null;
    }

    public Object getDelegateSession() throws UMOException {
        return null;
    }

    public UMOConnector getConnector() {
        return this.connector;
    }

    public void doDispose() throws UMOException {
        this.xmppConnection.close();
        this.initialized.set(false);
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        throw new UnsupportedOperationException("xmpp receive not implemented yet");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

