/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.PacketCollector;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.DisposeException;
import org.mule.InitialisationException;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOException;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class XmppMessageReceiver
extends AbstractMessageReceiver
implements PacketListener {
    private XMPPConnection xmppConnection = null;
    private PooledExecutor threadPool;
    private Thread worker;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$Message;
    static /* synthetic */ Class class$org$mule$providers$xmpp$XmppMessageReceiver$XMPPWorker;

    public XmppMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        this.create((UMOConnector)connector, component, endpoint);
        this.threadPool = connector.getReceiverThreadingProfile().createPool();
        this.connect(endpoint.getEndpointURI().getUri());
    }

    protected void connect(URI uri) throws InitialisationException {
        try {
            this.logger.info((Object)"*************************************");
            this.logger.info((Object)"*            JABBER LOGIN           *");
            this.logger.info((Object)"*************************************");
            XmppConnector cnn = (XmppConnector)this.connector;
            String serverName = cnn.getServerName();
            String userName = cnn.getUsername();
            String login = cnn.getPassword();
            try {
                this.xmppConnection = new XMPPConnection(serverName);
                AccountManager accManager = new AccountManager(this.xmppConnection);
                accManager.createAccount(userName, login);
            }
            catch (XMPPException ex) {
                this.logger.info((Object)"*** mule outbound account already exists ***");
            }
            this.logger.info((Object)("Logging in as: " + userName));
            this.logger.info((Object)("pw is        : " + login));
            this.logger.info((Object)("server       : " + serverName));
            this.xmppConnection = new XMPPConnection(serverName);
            this.xmppConnection.login(userName, login);
            this.logger.info((Object)"JABBER LOGIN COMPLETE!");
            PacketTypeFilter filter = new PacketTypeFilter(class$org$jivesoftware$smack$packet$Message == null ? (class$org$jivesoftware$smack$packet$Message = XmppMessageReceiver.class$("org.jivesoftware.smack.packet.Message")) : class$org$jivesoftware$smack$packet$Message);
            PacketCollector myCollector = this.xmppConnection.createPacketCollector((PacketFilter)filter);
            this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)filter);
        }
        catch (XMPPException e) {
            throw new InitialisationException("Failed to make xmpp connection: " + e.getMessage(), (Throwable)e);
        }
    }

    public void doDispose() throws UMOException {
        if (this.worker != null) {
            this.worker.interrupt();
            this.worker = null;
        }
        try {
            this.threadPool.shutdownAfterProcessingCurrentlyQueuedTasks();
            this.threadPool.awaitTerminationAfterShutdown();
        }
        catch (Exception e) {
            throw new DisposeException("Failed to close http port: " + e.getMessage(), (Throwable)e);
        }
        this.logger.info((Object)"Closed Tcp port");
    }

    protected Runnable createWorker(Message message) {
        return new XMPPWorker(message);
    }

    public void processPacket(Packet arg0) {
        Message msg = (Message)arg0;
        Runnable worker = this.createWorker(msg);
        try {
            this.threadPool.execute(worker);
        }
        catch (InterruptedException e) {
            this.logger.error((Object)("Tcp Server receiver interrupted: " + e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XMPPWorker
    implements Runnable {
        Message message = null;
        protected transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$xmpp$XmppMessageReceiver$XMPPWorker == null ? (class$org$mule$providers$xmpp$XmppMessageReceiver$XMPPWorker = XmppMessageReceiver.class$("org.mule.providers.xmpp.XmppMessageReceiver$XMPPWorker")) : class$org$mule$providers$xmpp$XmppMessageReceiver$XMPPWorker));

        public XMPPWorker(Message message) {
            this.message = message;
        }

        public void run() {
            try {
                this.logger.info((Object)("processing xmpp message from: " + this.message.getFrom()));
                UMOMessageAdapter adapter = XmppMessageReceiver.this.connector.getMessageAdapter((Object)this.message);
                this.logger.info((Object)("UMOMessageAdapter is a: " + adapter.getClass().getName()));
                UMOMessage returnMessage = XmppMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), XmppMessageReceiver.this.endpoint.isSynchronous());
                if (returnMessage != null) {
                    XmppMessageReceiver.this.xmppConnection.sendPacket((Packet)new Message(returnMessage.getPayloadAsString()));
                }
            }
            catch (Exception e) {
                XmppMessageReceiver.this.handleException("Something bad happened processing xmpp message: ", e);
            }
        }
    }
}

