/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jivesoftware.smack.AccountManager;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.mule.providers.AbstractServiceEnabledConnector;
import org.mule.umo.endpoint.UMOEndpointURI;

public class XmppConnector
extends AbstractServiceEnabledConnector {
    private static final String DEFAULT_RESOURCE = "mule";
    private Map connCache = new HashMap();

    public String getProtocol() {
        return "xmpp";
    }

    public XMPPConnection findOrCreateXmppConnection(UMOEndpointURI endpointURI) throws XMPPException {
        this.logger.info((Object)("Trying to find XMPP connection for uri: " + endpointURI));
        XMPPConnection xmppConnection = null;
        String username = endpointURI.getUsername();
        String hostname = endpointURI.getHost();
        String password = endpointURI.getPassword();
        String resource = endpointURI.getPath();
        resource = resource == null || "".equals(resource) ? DEFAULT_RESOURCE : resource.substring(1);
        xmppConnection = this.findOrCreateConnection(endpointURI);
        this.logger.info((Object)"*************************************");
        this.logger.info((Object)"*            JABBER LOGIN           *");
        this.logger.info((Object)"*************************************");
        if (!xmppConnection.isAuthenticated()) {
            try {
                AccountManager accManager = new AccountManager(xmppConnection);
                accManager.createAccount(username, password);
            }
            catch (XMPPException ex) {
                this.logger.info((Object)("*** account (" + username + ") already exists ***"));
            }
            this.logger.info((Object)("Logging in as: " + username));
            this.logger.info((Object)("pw is        : " + password));
            this.logger.info((Object)("server       : " + hostname));
            this.logger.info((Object)("resource     : " + resource));
            xmppConnection.login(username, password, resource);
        } else {
            this.logger.info((Object)"Already authenticated on this connection, no need to log in again.");
        }
        this.logger.info((Object)"XMPP LOGIN COMPLETE!");
        return xmppConnection;
    }

    private XMPPConnection findOrCreateConnection(UMOEndpointURI uri) throws XMPPException {
        XMPPConnection conn = (XMPPConnection)this.connCache.get(uri);
        if (null == conn) {
            conn = new XMPPConnection(uri.getHost());
            this.connCache.put(uri, conn);
        }
        return conn;
    }

    protected void doDispose() {
        Iterator iterator = this.connCache.keySet().iterator();
        while (iterator.hasNext()) {
            UMOEndpointURI uri = (UMOEndpointURI)iterator.next();
            XMPPConnection conn = (XMPPConnection)this.connCache.remove(uri);
            conn.close();
        }
    }
}

