/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import java.util.Iterator;
import org.jivesoftware.smack.packet.Message;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UniqueIdNotSupportedException;

public class XmppMessageAdapter
extends AbstractMessageAdapter {
    private Message message;

    public XmppMessageAdapter(Object message) throws MessagingException {
        if (message instanceof Message) {
            this.message = (Message)message;
            Iterator iter = this.message.getPropertyNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.setProperty(name, this.message.getProperty(name));
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
        this.setProperty("subject", this.message.getSubject());
        this.setProperty("thread", this.message.getThread());
    }

    public String getPayloadAsString() throws Exception {
        return this.message.getBody();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        return this.message.getBody().getBytes();
    }

    public Object getPayload() {
        return this.message;
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        return this.message.getPacketID();
    }
}

