/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import EDU.oswego.cs.dl.util.concurrent.SynchronizedBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;

public class XmppMessageDispatcher
extends AbstractMessageDispatcher {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$xmpp$XmppMessageDispatcher == null ? (class$org$mule$providers$xmpp$XmppMessageDispatcher = XmppMessageDispatcher.class$("org.mule.providers.xmpp.XmppMessageDispatcher")) : class$org$mule$providers$xmpp$XmppMessageDispatcher));
    private XmppConnector connector;
    private SynchronizedBoolean initialized = new SynchronizedBoolean(false);
    private XMPPConnection xmppConnection = null;
    static /* synthetic */ Class class$org$mule$providers$xmpp$XmppMessageDispatcher;

    public XmppMessageDispatcher(AbstractConnector connector) {
        super(connector);
        this.connector = (XmppConnector)connector;
    }

    protected synchronized void initialize(UMOEndpointURI uri) throws InitialisationException {
        logger.debug((Object)"initialise()");
        if (!this.initialized.get()) {
            try {
                this.xmppConnection = this.connector.findOrCreateXmppConnection(uri);
                if (!this.xmppConnection.isConnected()) {
                    throw new InitialisationException(new org.mule.config.i18n.Message(74, (Object)"XMPP Connection", (Object)uri), (Object)this);
                }
                this.initialized.set(true);
            }
            catch (XMPPException e) {
                throw new InitialisationException((Throwable)e, (Object)this);
            }
        }
    }

    public void doDispose() {
        logger.debug((Object)"doDipose()");
        if (null != this.xmppConnection) {
            this.xmppConnection.close();
        }
        this.initialized.set(false);
    }

    public void doDispatch(UMOEvent event) throws Exception {
        logger.info((Object)"in doDispatch()");
        this.initialize(event.getEndpoint().getEndpointURI());
        try {
            Message message = (Message)event.getTransformedMessage();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Transformed message: " + message.toXML()));
            }
            while (!this.xmppConnection.isConnected() && !this.initialized.get()) {
                this.initialize(null);
                Thread.sleep(150L);
            }
            try {
                this.xmppConnection.createChat(message.getTo()).sendMessage(message);
                logger.debug((Object)"message successfully sent");
            }
            catch (IllegalStateException ex) {
                this.connector.exceptionThrown(ex);
            }
        }
        catch (ClassCastException ex) {
            this.connector.handleException(ex);
        }
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        logger.debug((Object)"doSend()");
        this.doDispatch(event);
        return null;
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        logger.debug((Object)"receive()");
        throw new UnsupportedOperationException("xmpp receive not implemented yet");
    }

    public Object getDelegateSession() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

