/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkException;
import org.jivesoftware.smack.PacketListener;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.filter.PacketFilter;
import org.jivesoftware.smack.filter.PacketTypeFilter;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageReceiver;
import org.mule.providers.ConnectException;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOComponent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.UMOEndpoint;
import org.mule.umo.lifecycle.InitialisationException;
import org.mule.umo.provider.UMOConnector;
import org.mule.umo.provider.UMOMessageAdapter;

public class XmppMessageReceiver
extends AbstractMessageReceiver
implements PacketListener {
    private XMPPConnection xmppConnection = null;
    static /* synthetic */ Class class$org$jivesoftware$smack$packet$Message;

    public XmppMessageReceiver(AbstractConnector connector, UMOComponent component, UMOEndpoint endpoint) throws InitialisationException {
        super((UMOConnector)connector, component, endpoint);
    }

    public void doConnect() throws Exception {
        try {
            XmppConnector cnn = (XmppConnector)this.connector;
            this.xmppConnection = cnn.findOrCreateXmppConnection(this.endpoint.getEndpointURI());
            if (this.endpoint.getFilter() instanceof PacketFilter) {
                this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)this.endpoint.getFilter());
            } else {
                PacketTypeFilter filter = new PacketTypeFilter(class$org$jivesoftware$smack$packet$Message == null ? (class$org$jivesoftware$smack$packet$Message = XmppMessageReceiver.class$("org.jivesoftware.smack.packet.Message")) : class$org$jivesoftware$smack$packet$Message);
                this.xmppConnection.addPacketListener((PacketListener)this, (PacketFilter)filter);
            }
        }
        catch (XMPPException e) {
            throw new ConnectException(new org.mule.config.i18n.Message(65, (Object)"XMPP Connection"), (Throwable)e, (Object)this);
        }
    }

    public void doDisconnect() throws Exception {
        if (this.xmppConnection != null) {
            this.xmppConnection.removePacketListener((PacketListener)this);
            this.xmppConnection.close();
        }
    }

    public void doDispose() {
        this.logger.info((Object)"Closed Xmpp Listener");
    }

    protected Work createWork(Message message) {
        return new XMPPWorker(message);
    }

    public void processPacket(Packet packet) {
        this.logger.debug((Object)("processing packet: " + packet.toXML()));
        Message msg = (Message)packet;
        Work work = this.createWork(msg);
        try {
            this.getWorkManager().scheduleWork(work, 0L, null, null);
        }
        catch (WorkException e) {
            this.logger.error((Object)("Xmpp Server receiver work failed: " + e.getMessage()), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class XMPPWorker
    implements Work {
        Message message = null;

        public XMPPWorker(Message message) {
            this.message = message;
        }

        public void run() {
            try {
                XmppMessageReceiver.this.logger.info((Object)("processing xmpp message from: " + this.message.getFrom()));
                UMOMessageAdapter adapter = XmppMessageReceiver.this.connector.getMessageAdapter((Object)this.message);
                XmppMessageReceiver.this.logger.info((Object)("UMOMessageAdapter is a: " + adapter.getClass().getName()));
                UMOMessage returnMessage = XmppMessageReceiver.this.routeMessage((UMOMessage)new MuleMessage(adapter), XmppMessageReceiver.this.endpoint.isSynchronous());
                if (returnMessage != null) {
                    XmppMessageReceiver.this.xmppConnection.sendPacket((Packet)new Message(returnMessage.getPayloadAsString()));
                }
            }
            catch (Exception e) {
                XmppMessageReceiver.this.handleException(e);
            }
        }

        public void release() {
        }
    }
}

