/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import java.util.Iterator;
import org.jivesoftware.smack.packet.Message;
import org.jivesoftware.smack.packet.Packet;
import org.mule.providers.AbstractMessageAdapter;
import org.mule.umo.MessagingException;
import org.mule.umo.provider.MessageTypeNotSupportedException;
import org.mule.umo.provider.UniqueIdNotSupportedException;

public class XmppMessageAdapter
extends AbstractMessageAdapter {
    private Packet message;

    public XmppMessageAdapter(Object message) throws MessagingException {
        if (message instanceof Packet) {
            this.message = (Packet)message;
            Iterator iter = this.message.getPropertyNames();
            while (iter.hasNext()) {
                String name = (String)iter.next();
                this.setProperty(name, this.message.getProperty(name));
            }
            if (this.message instanceof Message) {
                this.setProperty("subject", ((Message)this.message).getSubject());
                this.setProperty("thread", ((Message)this.message).getThread());
            }
        } else {
            throw new MessageTypeNotSupportedException(message, ((Object)((Object)this)).getClass());
        }
    }

    public String getPayloadAsString() throws Exception {
        if (this.message instanceof Message) {
            return ((Message)this.message).getBody();
        }
        return this.message.toString();
    }

    public byte[] getPayloadAsBytes() throws Exception {
        if (this.message instanceof Message) {
            return ((Message)this.message).getBody().getBytes();
        }
        return this.message.toString().getBytes();
    }

    public Object getPayload() {
        return this.message;
    }

    public String getUniqueId() throws UniqueIdNotSupportedException {
        return this.message.getPacketID();
    }
}

