/*
 * Decompiled with CFR 0.152.
 */
package org.mule.providers.xmpp;

import edu.emory.mathcs.backport.java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jivesoftware.smack.Chat;
import org.jivesoftware.smack.GroupChat;
import org.jivesoftware.smack.XMPPConnection;
import org.jivesoftware.smack.XMPPException;
import org.jivesoftware.smack.packet.Message;
import org.mule.impl.MuleMessage;
import org.mule.providers.AbstractConnector;
import org.mule.providers.AbstractMessageDispatcher;
import org.mule.providers.xmpp.XmppConnector;
import org.mule.umo.UMOEvent;
import org.mule.umo.UMOMessage;
import org.mule.umo.endpoint.MalformedEndpointException;
import org.mule.umo.endpoint.UMOEndpointURI;
import org.mule.umo.lifecycle.InitialisationException;

public class XmppMessageDispatcher
extends AbstractMessageDispatcher {
    protected static transient Log logger = LogFactory.getLog((Class)(class$org$mule$providers$xmpp$XmppMessageDispatcher == null ? (class$org$mule$providers$xmpp$XmppMessageDispatcher = XmppMessageDispatcher.class$("org.mule.providers.xmpp.XmppMessageDispatcher")) : class$org$mule$providers$xmpp$XmppMessageDispatcher));
    private XmppConnector connector;
    private AtomicBoolean initialized = new AtomicBoolean(false);
    private XMPPConnection xmppConnection = null;
    private Chat chat;
    private GroupChat groupChat;
    static /* synthetic */ Class class$org$mule$providers$xmpp$XmppMessageDispatcher;

    public XmppMessageDispatcher(AbstractConnector connector) {
        super(connector);
        this.connector = (XmppConnector)connector;
    }

    protected synchronized void initialize(UMOEndpointURI uri) throws InitialisationException {
        logger.debug((Object)"initialise()");
        if (!this.initialized.get()) {
            try {
                this.xmppConnection = this.connector.findOrCreateXmppConnection(uri);
                if (!this.xmppConnection.isConnected()) {
                    throw new InitialisationException(new org.mule.config.i18n.Message(74, (Object)"XMPP Connection", (Object)uri), (Object)this);
                }
                this.initialized.set(true);
            }
            catch (XMPPException e) {
                throw new InitialisationException((Throwable)e, (Object)this);
            }
        }
    }

    public void doDispose() {
        if (this.groupChat != null) {
            this.groupChat.leave();
        }
        if (null != this.xmppConnection) {
            this.xmppConnection.close();
        }
        this.initialized.set(false);
    }

    public void doDispatch(UMOEvent event) throws Exception {
        this.sendMessage(event);
    }

    public UMOMessage doSend(UMOEvent event) throws Exception {
        this.sendMessage(event);
        if (this.useRemoteSync(event)) {
            Message response = null;
            response = this.groupChat != null ? this.groupChat.nextMessage((long)event.getEndpoint().getRemoteSyncTimeout()) : this.chat.nextMessage((long)event.getEndpoint().getRemoteSyncTimeout());
            if (response != null) {
                logger.debug((Object)("Got a response from chat: " + this.chat));
                return new MuleMessage((Object)this.connector.getMessageAdapter(response));
            }
        }
        return null;
    }

    protected void sendMessage(UMOEvent event) throws Exception {
        this.initialize(event.getEndpoint().getEndpointURI());
        if (this.chat == null && this.groupChat == null) {
            boolean group = event.getBooleanProperty("groupChat", false);
            String nickname = (String)event.getProperty("nickname", (Object)"mule");
            String recipient = event.getEndpoint().getEndpointURI().getPath().substring(1);
            if (group) {
                this.groupChat = new GroupChat(this.xmppConnection, recipient);
                if (!this.groupChat.isJoined()) {
                    this.groupChat.join(nickname);
                }
            } else {
                this.chat = new Chat(this.xmppConnection, recipient);
            }
        }
        Message message = (Message)event.getTransformedMessage();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Transformed packet: " + message.toXML()));
        }
        while (!this.xmppConnection.isConnected() && !this.initialized.get()) {
            this.initialize(null);
            Thread.sleep(150L);
        }
        if (this.chat != null) {
            this.chat.sendMessage(message);
        } else {
            this.groupChat.sendMessage(message);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"packet successfully sent");
        }
    }

    public UMOMessage receive(UMOEndpointURI endpointUri, long timeout) throws Exception {
        while (!this.xmppConnection.isConnected() && !this.initialized.get()) {
            this.initialize(null);
            Thread.sleep(150L);
        }
        String to = (String)endpointUri.getParams().get("folder");
        if (to == null) {
            throw new MalformedEndpointException(endpointUri.toString());
        }
        Chat chat = this.xmppConnection.createChat(to);
        Message message = null;
        message = timeout == 0L ? chat.nextMessage() : (timeout == -1L ? chat.nextMessage(1L) : chat.nextMessage(timeout));
        if (message != null) {
            return new MuleMessage((Object)this.connector.getMessageAdapter(message));
        }
        return null;
    }

    public Object getDelegateSession() {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

