/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.ui.view.components.signature;

import android.annotation.SuppressLint;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.Nullable;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import mx.com.atriz.widgets.R;
import mx.com.atriz.widgets.ui.view.components.signature.Point;

public class SignatureView
extends View {
    private Canvas canvasBmp;
    private boolean ignoreTouch;
    private Point previousPoint;
    private Point startPoint;
    private Point currentPoint;
    public static final float MIN_PEN_SIZE = 1.0f;
    private static final float MIN_INCREMENT = 0.01f;
    private static final float INCREMENT_CONSTANT = 5.0E-4f;
    private static final float DRAWING_CONSTANT = 0.0085f;
    public static final float MAX_VELOCITY_BOUND = 15.0f;
    private static final float MIN_VELOCITY_BOUND = 1.6f;
    private static final float STROKE_DES_VELOCITY = 1.0f;
    private static final float VELOCITY_FILTER_WEIGHT = 0.2f;
    private float lastVelocity;
    private float lastWidth;
    private Paint paint;
    private Paint paintBm;
    private Bitmap bmp;
    private int layoutLeft;
    private int layoutTop;
    private int layoutRight;
    private int layoutBottom;
    private Rect drawViewRect;
    private int penColor;
    private int backgroundColor;
    private boolean enableSignature;
    private float penSize;
    private final TypedArray typedArray;

    public SignatureView(Context context) {
        super(context);
        this.typedArray = context.getTheme().obtainStyledAttributes(null, R.styleable.SignatureView, 0, 0);
        this.init(context);
    }

    public SignatureView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SignatureView, 0, 0);
        this.init(context);
    }

    public SignatureView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SignatureView, defStyleAttr, 0);
        this.init(context);
    }

    public SignatureView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SignatureView, defStyleAttr, defStyleRes);
        this.init(context);
    }

    private void init(Context context) {
        try {
            this.backgroundColor = this.typedArray.getColor(R.styleable.SignatureView_toBackgroundColor, -1);
            this.penColor = this.typedArray.getColor(R.styleable.SignatureView_toPenColor, -16777216);
            this.penSize = this.typedArray.getDimension(R.styleable.SignatureView_toPenSize, context.getResources().getDimension(R.dimen.pen_size));
            this.enableSignature = this.typedArray.getBoolean(R.styleable.SignatureView_toEnable, true);
        }
        finally {
            this.typedArray.recycle();
        }
        this.paint = new Paint(1);
        this.paint.setColor(this.penColor);
        this.paint.setAntiAlias(true);
        this.paint.setStyle(Paint.Style.FILL_AND_STROKE);
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStrokeCap(Paint.Cap.ROUND);
        this.paint.setStrokeWidth(this.penSize);
        this.paintBm = new Paint(1);
        this.paintBm.setAntiAlias(true);
        this.paintBm.setStyle(Paint.Style.STROKE);
        this.paintBm.setStrokeJoin(Paint.Join.ROUND);
        this.paintBm.setStrokeCap(Paint.Cap.ROUND);
        this.paintBm.setColor(-16777216);
    }

    public float getPenSize() {
        return this.penSize;
    }

    public void setPenSize(float penSize) {
        this.penSize = penSize;
    }

    public boolean isEnableSignature() {
        return this.enableSignature;
    }

    public void setEnableSignature(boolean enableSignature) {
        this.enableSignature = enableSignature;
    }

    public int getPenColor() {
        return this.penColor;
    }

    public void setPenColor(int penColor) {
        this.penColor = penColor;
        this.paint.setColor(penColor);
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(int backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    public void clearCanvas() {
        this.previousPoint = null;
        this.startPoint = null;
        this.currentPoint = null;
        this.lastVelocity = 0.0f;
        this.lastWidth = 0.0f;
        this.newBitmapCanvas(this.layoutLeft, this.layoutTop, this.layoutRight, this.layoutBottom);
        this.postInvalidate();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.layoutLeft = left;
        this.layoutTop = top;
        this.layoutRight = right;
        this.layoutBottom = bottom;
        if (this.bmp == null) {
            this.newBitmapCanvas(this.layoutLeft, this.layoutTop, this.layoutRight, this.layoutBottom);
        } else if (changed) {
            this.resizeBitmapCanvas(this.bmp, this.layoutLeft, this.layoutTop, this.layoutRight, this.layoutBottom);
        }
    }

    private void newBitmapCanvas(int left, int top, int right, int bottom) {
        this.bmp = null;
        this.canvasBmp = null;
        if (right - left > 0 && bottom - top > 0) {
            this.bmp = Bitmap.createBitmap((int)(right - left), (int)(bottom - top), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvasBmp = new Canvas(this.bmp);
            this.canvasBmp.drawColor(this.backgroundColor);
        }
    }

    private void resizeBitmapCanvas(Bitmap bmp, int left, int top, int right, int bottom) {
        int newBottom = Math.max(bottom, bmp.getHeight());
        int newRight = Math.max(right, bmp.getWidth());
        this.newBitmapCanvas(left, top, newRight, newBottom);
        this.canvasBmp.drawBitmap(bmp, 0.0f, 0.0f, null);
    }

    @SuppressLint(value={"ClickableViewAccessibility"})
    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (!this.isEnableSignature()) {
            return false;
        }
        if (event.getPointerCount() > 1) {
            return false;
        }
        switch (event.getAction()) {
            case 0: {
                this.ignoreTouch = false;
                this.drawViewRect = new Rect(this.getLeft(), this.getTop(), this.getRight(), this.getBottom());
                this.onTouchDownEvent(event.getX(), event.getY());
                break;
            }
            case 2: {
                if (!this.drawViewRect.contains(this.getLeft() + (int)event.getX(), this.getTop() + (int)event.getY())) {
                    if (this.ignoreTouch) break;
                    this.ignoreTouch = true;
                    this.onTouchUpEvent(event.getX(), event.getY());
                    break;
                }
                if (this.ignoreTouch) {
                    this.ignoreTouch = false;
                    this.onTouchDownEvent(event.getX(), event.getY());
                    break;
                }
                this.onTouchMoveEvent(event.getX(), event.getY());
                break;
            }
            case 1: 
            case 3: {
                this.onTouchUpEvent(event.getX(), event.getY());
                break;
            }
        }
        return true;
    }

    private void onTouchDownEvent(float x, float y) {
        this.previousPoint = null;
        this.startPoint = null;
        this.currentPoint = null;
        this.lastVelocity = 0.0f;
        this.lastWidth = this.penSize;
        this.startPoint = this.previousPoint = (this.currentPoint = new Point(x, y, System.currentTimeMillis()));
        this.postInvalidate();
    }

    private void onTouchMoveEvent(float x, float y) {
        if (this.previousPoint == null) {
            return;
        }
        this.startPoint = this.previousPoint;
        this.previousPoint = this.currentPoint;
        this.currentPoint = new Point(x, y, System.currentTimeMillis());
        float velocity = this.currentPoint.velocityFrom(this.previousPoint);
        velocity = 0.2f * velocity + 0.8f * this.lastVelocity;
        float strokeWidth = this.getStrokeWidth(velocity);
        this.drawLine(this.lastWidth, strokeWidth, velocity);
        this.lastVelocity = velocity;
        this.lastWidth = strokeWidth;
        this.postInvalidate();
    }

    private void onTouchUpEvent(float x, float y) {
        if (this.previousPoint == null) {
            return;
        }
        this.startPoint = this.previousPoint;
        this.previousPoint = this.currentPoint;
        this.currentPoint = new Point(x, y, System.currentTimeMillis());
        this.drawLine(this.lastWidth, 0.0f, this.lastVelocity);
        this.postInvalidate();
    }

    private float getStrokeWidth(float velocity) {
        return this.penSize - velocity * 1.0f;
    }

    protected void onDraw(Canvas canvas) {
        canvas.drawBitmap(this.bmp, 0.0f, 0.0f, this.paintBm);
    }

    private void drawLine(float lastWidth, float currentWidth, float velocity) {
        Point mid1 = this.midPoint(this.previousPoint, this.startPoint);
        Point mid2 = this.midPoint(this.currentPoint, this.previousPoint);
        this.draw(mid1, this.previousPoint, mid2, lastWidth, currentWidth, velocity);
    }

    private float getPt(float n1, float n2, float perc) {
        float diff = n2 - n1;
        return n1 + diff * perc;
    }

    private void draw(Point p0, Point p1, Point p2, float lastWidth, float currentWidth, float velocity) {
        if (this.canvasBmp != null) {
            float increment = velocity > 1.6f && velocity < 15.0f ? 0.0085f - velocity * 5.0E-4f : 0.01f;
            for (float i = 0.0f; i < 1.0f; i += increment) {
                float xa = this.getPt(p0.x, p1.x, i);
                float ya = this.getPt(p0.y, p1.y, i);
                float xb = this.getPt(p1.x, p2.x, i);
                float yb = this.getPt(p1.y, p2.y, i);
                float x = this.getPt(xa, xb, i);
                float y = this.getPt(ya, yb, i);
                float strokeVal = lastWidth + (currentWidth - lastWidth) * i;
                this.paint.setStrokeWidth(Math.max(strokeVal, 1.0f));
                this.canvasBmp.drawPoint(x, y, this.paint);
            }
        }
    }

    private Point midPoint(Point p1, Point p2) {
        return new Point((p1.x + p2.x) / 2.0f, (p1.y + p2.y) / 2.0f, (p1.time + p2.time) / 2L);
    }

    public Bitmap getSignatureBitmap() {
        if (this.bmp != null) {
            return Bitmap.createScaledBitmap((Bitmap)this.bmp, (int)this.bmp.getWidth(), (int)this.bmp.getHeight(), (boolean)true);
        }
        return null;
    }

    public void setBitmap(Bitmap bitmap) {
        if (bitmap != null) {
            this.bmp = bitmap;
            this.canvasBmp = new Canvas(bitmap);
            this.postInvalidate();
        }
    }

    public boolean isBitmapEmpty() {
        if (this.bmp != null) {
            Bitmap emptyBitmap = Bitmap.createBitmap((int)this.bmp.getWidth(), (int)this.bmp.getHeight(), (Bitmap.Config)this.bmp.getConfig());
            Canvas canvas = new Canvas(emptyBitmap);
            canvas.drawColor(this.backgroundColor);
            return this.bmp.sameAs(emptyBitmap);
        }
        return false;
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        return new SavedState(superState, this.bmp);
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setBitmap(ss.bitmap);
    }

    static class SavedState
    extends View.BaseSavedState {
        Bitmap bitmap;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState, Bitmap bitmap) {
            super(superState);
            this.bitmap = bitmap;
        }

        private SavedState(Parcel in) {
            super(in);
            this.bitmap = SavedState.deCompress(in.createByteArray());
        }

        public void writeToParcel(Parcel out, int flags) {
            super.writeToParcel(out, flags);
            out.writeByteArray(SavedState.compress(this.bitmap));
        }

        private static byte[] compress(Bitmap bitmap) {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            bitmap.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)stream);
            return stream.toByteArray();
        }

        private static Bitmap deCompress(byte[] byteArray) {
            return BitmapFactory.decodeByteArray((byte[])byteArray, (int)0, (int)byteArray.length);
        }
    }
}

