/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.ui.view.fragments;

import android.app.Dialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.compose.runtime.internal.StabilityInferred;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import com.google.android.material.R;
import com.google.android.material.bottomsheet.BottomSheetBehavior;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.android.material.bottomsheet.BottomSheetDialogFragment;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mx.com.atriz.core.entities.Permission;
import mx.com.atriz.core.ext.ActivitiesKt;
import mx.com.atriz.core.interfaces.AppInterface;
import mx.com.atriz.widgets.R;
import mx.com.atriz.widgets.databinding.DialogPermissionBinding;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u001a\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u000b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0016J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u000bH\u0002J\u0010\u0010\u0019\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u001bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001c\u001a\u0010\u0012\f\u0012\n \u001f*\u0004\u0018\u00010\u001e0\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R(\u0010 \u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u001e \u001f*\n\u0012\u0004\u0012\u00020\u001e\u0018\u00010!0!0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lmx/com/atriz/widgets/ui/view/fragments/PermissionFragment;", "Lcom/google/android/material/bottomsheet/BottomSheetDialogFragment;", "permission", "Lmx/com/atriz/core/entities/Permission;", "<init>", "(Lmx/com/atriz/core/entities/Permission;)V", "binding", "Lmx/com/atriz/widgets/databinding/DialogPermissionBinding;", "listener", "Lmx/com/atriz/core/interfaces/AppInterface;", "onCreateView", "Landroid/view/View;", "inflater", "Landroid/view/LayoutInflater;", "container", "Landroid/view/ViewGroup;", "savedInstanceState", "Landroid/os/Bundle;", "onViewCreated", "", "view", "onCreateDialog", "Landroid/app/Dialog;", "setupFullHeight", "bottomSheet", "onAttach", "context", "Landroid/content/Context;", "singlePermissionLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "", "kotlin.jvm.PlatformType", "multiplePermissionLauncher", "", "widgets_release"})
@StabilityInferred(parameters=0)
public final class PermissionFragment
extends BottomSheetDialogFragment {
    @NotNull
    private final Permission permission;
    private DialogPermissionBinding binding;
    @Nullable
    private AppInterface listener;
    @NotNull
    private final ActivityResultLauncher<String> singlePermissionLauncher;
    @NotNull
    private final ActivityResultLauncher<String[]> multiplePermissionLauncher;
    public static final int $stable = 8;

    public PermissionFragment(@NotNull Permission permission) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        this.permission = permission;
        this.setCancelable(false);
        ActivityResultLauncher activityResultLauncher = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestPermission(), arg_0 -> PermissionFragment.singlePermissionLauncher$lambda$4(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher, (String)"registerForActivityResult(...)");
        this.singlePermissionLauncher = activityResultLauncher;
        ActivityResultLauncher activityResultLauncher2 = this.registerForActivityResult((ActivityResultContract)new ActivityResultContracts.RequestMultiplePermissions(), arg_0 -> PermissionFragment.multiplePermissionLauncher$lambda$5(this, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)activityResultLauncher2, (String)"registerForActivityResult(...)");
        this.multiplePermissionLauncher = activityResultLauncher2;
    }

    @NotNull
    public View onCreateView(@NotNull LayoutInflater inflater, @Nullable ViewGroup container, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)inflater, (String)"inflater");
        this.binding = DialogPermissionBinding.bind(inflater.inflate(R.layout.dialog_permission, container));
        DialogPermissionBinding dialogPermissionBinding = this.binding;
        if (dialogPermissionBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogPermissionBinding = null;
        }
        ConstraintLayout constraintLayout = dialogPermissionBinding.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)constraintLayout, (String)"getRoot(...)");
        return (View)constraintLayout;
    }

    public void onViewCreated(@NotNull View view, @Nullable Bundle savedInstanceState) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        super.onViewCreated(view, savedInstanceState);
        DialogPermissionBinding dialogPermissionBinding = this.binding;
        if (dialogPermissionBinding == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogPermissionBinding = null;
        }
        dialogPermissionBinding.title.setText(this.getText(this.permission.getTitle()));
        DialogPermissionBinding dialogPermissionBinding2 = this.binding;
        if (dialogPermissionBinding2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogPermissionBinding2 = null;
        }
        dialogPermissionBinding2.description.setText(this.getText(this.permission.getExplanation()));
        DialogPermissionBinding dialogPermissionBinding3 = this.binding;
        if (dialogPermissionBinding3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogPermissionBinding3 = null;
        }
        Integer n = this.permission.getBackground();
        dialogPermissionBinding3.background.setImageResource(n != null ? n : 0);
        DialogPermissionBinding dialogPermissionBinding4 = this.binding;
        if (dialogPermissionBinding4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogPermissionBinding4 = null;
        }
        dialogPermissionBinding4.askPermission.setOnClickListener(arg_0 -> PermissionFragment.onViewCreated$lambda$0(this, arg_0));
        DialogPermissionBinding dialogPermissionBinding5 = this.binding;
        if (dialogPermissionBinding5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"binding");
            dialogPermissionBinding5 = null;
        }
        dialogPermissionBinding5.privacy.setOnClickListener(arg_0 -> PermissionFragment.onViewCreated$lambda$1(this, arg_0));
    }

    @NotNull
    public Dialog onCreateDialog(@Nullable Bundle savedInstanceState) {
        BottomSheetDialog dialog = new BottomSheetDialog(this.requireContext(), this.getTheme());
        dialog.setOnShowListener(arg_0 -> PermissionFragment.onCreateDialog$lambda$3(this, arg_0));
        return (Dialog)dialog;
    }

    private final void setupFullHeight(View bottomSheet) {
        ViewGroup.LayoutParams layoutParams = bottomSheet.getLayoutParams();
        layoutParams.height = -1;
        bottomSheet.setLayoutParams(layoutParams);
    }

    public void onAttach(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super.onAttach(context);
        if (context instanceof AppInterface) {
            this.listener = (AppInterface)context;
        }
    }

    private static final void onViewCreated$lambda$0(PermissionFragment this$0, View it) {
        if (this$0.permission.getPermissionList().length > 1) {
            this$0.multiplePermissionLauncher.launch((Object)this$0.permission.getPermissionList());
        } else {
            this$0.singlePermissionLauncher.launch((Object)this$0.permission.getPermissionList()[0]);
        }
    }

    private static final void onViewCreated$lambda$1(PermissionFragment this$0, View it) {
        Fragment fragment = (Fragment)this$0;
        String string2 = this$0.permission.getPolicyLink();
        if (string2 == null) {
            string2 = "";
        }
        ActivitiesKt.openBrowser((Fragment)fragment, (String)string2);
    }

    private static final void onCreateDialog$lambda$3(PermissionFragment this$0, DialogInterface it) {
        block0: {
            View parentLayout;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.google.android.material.bottomsheet.BottomSheetDialog");
            BottomSheetDialog bottomSheetDialog = (BottomSheetDialog)it;
            View view = parentLayout = bottomSheetDialog.findViewById(R.id.design_bottom_sheet);
            if (view == null) break block0;
            View layout2 = view;
            boolean bl = false;
            BottomSheetBehavior bottomSheetBehavior = BottomSheetBehavior.from((View)layout2);
            Intrinsics.checkNotNullExpressionValue((Object)bottomSheetBehavior, (String)"from(...)");
            BottomSheetBehavior behaviour = bottomSheetBehavior;
            this$0.setupFullHeight(layout2);
            behaviour.setState(3);
        }
    }

    private static final void singlePermissionLauncher$lambda$4(PermissionFragment this$0, Boolean singlePermission) {
        Intrinsics.checkNotNullParameter((Object)singlePermission, (String)"singlePermission");
        if (singlePermission.booleanValue()) {
            AppInterface appInterface = this$0.listener;
            if (appInterface != null) {
                appInterface.onPermissionGranted(this$0.permission.getType());
            }
        } else {
            AppInterface appInterface = this$0.listener;
            if (appInterface != null) {
                appInterface.onPermissionDenied(this$0.permission.getType());
            }
        }
        this$0.dismiss();
    }

    private static final void multiplePermissionLauncher$lambda$5(PermissionFragment this$0, Map permissions) {
        Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
        switch (WhenMappings.$EnumSwitchMapping$0[this$0.permission.getType().ordinal()]) {
            case 1: {
                boolean fine = permissions.getOrDefault("android.permission.ACCESS_FINE_LOCATION", false);
                boolean coarse = permissions.getOrDefault("android.permission.ACCESS_COARSE_LOCATION", false);
                if (fine || coarse) {
                    AppInterface appInterface = this$0.listener;
                    if (appInterface != null) {
                        appInterface.onPermissionGranted(Permission.Type.LOCATION);
                    }
                } else {
                    AppInterface appInterface = this$0.listener;
                    if (appInterface != null) {
                        appInterface.onPermissionDenied(Permission.Type.LOCATION);
                    }
                }
                break;
            }
            case 2: {
                boolean background;
                boolean fine = permissions.getOrDefault("android.permission.ACCESS_FINE_LOCATION", false);
                boolean coarse = permissions.getOrDefault("android.permission.ACCESS_COARSE_LOCATION", false);
                boolean bl = background = Build.VERSION.SDK_INT >= 29 ? permissions.getOrDefault("android.permission.ACCESS_BACKGROUND_LOCATION", false) : true;
                if ((fine || coarse) && background) {
                    AppInterface appInterface = this$0.listener;
                    if (appInterface != null) {
                        appInterface.onPermissionGranted(Permission.Type.BACKGROUND_LOCATION);
                    }
                    break;
                }
                AppInterface appInterface = this$0.listener;
                if (appInterface == null) break;
                appInterface.onPermissionDenied(Permission.Type.BACKGROUND_LOCATION);
                break;
            }
        }
        this$0.dismiss();
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Permission.Type.values().length];
            try {
                nArray[Permission.Type.LOCATION.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Permission.Type.BACKGROUND_LOCATION.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

