/*
 * Decompiled with CFR 0.152.
 */
package mx.com.atriz.widgets.ui.view.recyclers.managers;

import android.graphics.PointF;
import android.view.View;
import android.view.animation.AccelerateInterpolator;
import android.view.animation.Interpolator;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.recyclerview.widget.LinearSmoothScroller;
import androidx.recyclerview.widget.LinearSnapHelper;
import androidx.recyclerview.widget.RecyclerView;
import java.security.InvalidParameterException;
import mx.com.atriz.widgets.ui.view.recyclers.managers.CardSliderLayoutManager;

public class CardSnapHelper
extends LinearSnapHelper {
    private RecyclerView recyclerView;

    public void attachToRecyclerView(@Nullable RecyclerView recyclerView) throws IllegalStateException {
        super.attachToRecyclerView(recyclerView);
        if (recyclerView != null && !(recyclerView.getLayoutManager() instanceof CardSliderLayoutManager)) {
            throw new InvalidParameterException("LayoutManager must be instance of CardSliderLayoutManager");
        }
        this.recyclerView = recyclerView;
    }

    public int findTargetSnapPosition(RecyclerView.LayoutManager layoutManager, int velocityX, int velocityY) {
        CardSliderLayoutManager lm = (CardSliderLayoutManager)layoutManager;
        int itemCount = lm.getItemCount();
        if (itemCount == 0) {
            return -1;
        }
        RecyclerView.SmoothScroller.ScrollVectorProvider vectorProvider = (RecyclerView.SmoothScroller.ScrollVectorProvider)layoutManager;
        PointF vectorForEnd = vectorProvider.computeScrollVectorForPosition(itemCount - 1);
        if (vectorForEnd == null) {
            return -1;
        }
        int distance = this.calculateScrollDistance(velocityX, velocityY)[0];
        int deltaJump = distance > 0 ? (int)Math.floor(distance / lm.getCardWidth()) : (int)Math.ceil(distance / lm.getCardWidth());
        int deltaSign = Integer.signum(deltaJump);
        deltaJump = deltaSign * Math.min(3, Math.abs(deltaJump));
        if (vectorForEnd.x < 0.0f) {
            deltaJump = -deltaJump;
        }
        if (deltaJump == 0) {
            return -1;
        }
        int currentPosition = lm.getActiveCardPosition();
        if (currentPosition == -1) {
            return -1;
        }
        int targetPos = currentPosition + deltaJump;
        if (targetPos < 0 || targetPos >= itemCount) {
            targetPos = -1;
        }
        return targetPos;
    }

    public View findSnapView(RecyclerView.LayoutManager layoutManager) {
        return ((CardSliderLayoutManager)layoutManager).getTopView();
    }

    public int[] calculateDistanceToFinalSnap(@NonNull RecyclerView.LayoutManager layoutManager, @NonNull View targetView) {
        int activeCardPos;
        int targetPos;
        CardSliderLayoutManager lm = (CardSliderLayoutManager)layoutManager;
        int viewLeft = lm.getDecoratedLeft(targetView);
        int activeCardLeft = lm.getActiveCardLeft();
        int activeCardCenter = lm.getActiveCardLeft() + lm.getCardWidth() / 2;
        int activeCardRight = lm.getActiveCardLeft() + lm.getCardWidth();
        int[] out = new int[]{0, 0};
        out[0] = viewLeft < activeCardCenter ? ((targetPos = lm.getPosition(targetView)) != (activeCardPos = lm.getActiveCardPosition()) ? -(activeCardPos - targetPos) * lm.getCardWidth() : viewLeft - activeCardLeft) : viewLeft - activeCardRight + 1;
        if (out[0] != 0) {
            this.recyclerView.smoothScrollBy(out[0], 0, (Interpolator)new AccelerateInterpolator());
        }
        return new int[]{0, 0};
    }

    @Nullable
    protected LinearSmoothScroller createSnapScroller(RecyclerView.LayoutManager layoutManager) {
        return ((CardSliderLayoutManager)layoutManager).getSmoothScroller(this.recyclerView);
    }
}

